/*
 linalg::setRow(A,p,r)   --  sets row p of A to row r
 
 A: matrix
 r: expression  
 p: positive integer
*/

linalg::setRow := proc(A,p,r)
  local T;
begin
 if testargs() then
   if args(0) <> 3 then error("expecting 3 arguments") end_if;
   if A::dom::hasProp( Cat::Matrix ) <> TRUE then
     error("first argument is not of 'Cat::Matrix'")
   end_if;
   if not testtype( p,Type::PosInt ) then
     error("index must be a positive integer")
   end_if;
   if p > op( A::dom::matdim(A),1 ) then
     error("index out of range")
   end_if
 end_if;

 T:= A::dom;
 if T::constructor = Dom::SquareMatrix then T:= T::getSuperDomain() end_if;
 case domtype(r)
 of T do
     break
 of DOM_LIST do
     r:= T::coerce( [r] );
     break
 otherwise
     r:= T::coerce(r)
 end_case;
 if r = FAIL then
     error("invalid row vector")
 elif r::dom::matdim(r) <> [1,A::dom::matdim(A)[2]] then
    error("row vector has an invalid dimension")
 else
    A::dom::setRow( A,p,r )
 end_if
end_proc:

