/*
        linalg::submatrix -- extract a specified matrix or vector from 
                             from a given matrix or vector

        submatrix(A, rows, cols)
        submatrix(v, comp)

        A          : matrix
        v          : vector
        rows, cols : lists or integer ranges of row/columns of A
        comp       : lists or integer ranges of components of v

 submatrix(A, rows, cols) returns the matrix of A selected
 by the row and col ranges, if rows and cols are integer ranges.
 Otherwise the matrix of A is selected whose (i,j)-th element
 is A(rows[i],cols[j]).

 submatrix(v,rows) does the same for a vector v.
*/

linalg::submatrix:= proc(A,rows)
    local cols, d, i, j;
begin
    if testargs() then
      if args(0) < 2 or args(0) > 3 then
        error("expecting 2 or 3 arguments")
      end_if;
      if A::dom::hasProp( Cat::Matrix ) <> TRUE then
        error("first argument is not of 'Cat::Matrix'")
      end_if;
      d:= A::dom::matdim(A);
      if args(0) = 2 and op(d,1) <> 1 and op(d,2) <> 1 then
        error("1st argument must be a vector, or give a third argument")
      end_if;
      if type(rows) = "_range" then
        if args(0) = 3 then
          i:= op(d,1); j := op(d,2);
          cols:= args(3);
          if type(cols) <> "_range" then
            error("3rd argument must be a range too")
          end_if;
          if not testtype(op(cols,1),Type::PosInt)
          or not testtype(op(cols,2),Type::PosInt) then
            error("3rd argument must be a range of positive integers")
          end_if;
          if op(cols,1) > op(cols,2) then
            error("lower > upper bound in range")
          end_if;
          if op(cols,1) > j or op(cols,2) > j then
            error("3rd argument: ranges larger than upper matrix bound")
          end_if
        else
          i:= max(op(d))
        end_if;
       if not testtype(op(rows,1),Type::PosInt)
       or not testtype(op(rows,2),Type::PosInt) then
         error("2nd argument must be a range of positive integers")
       end_if;
       if op(rows,1) > op(rows,2) then
         error("lower > upper bound in range")
       end_if;
     if op(rows,1) > i or op(rows,2) > i then
       error("2nd argument: ranges larger than upper matrix bound")
     end_if;
     delete i, j;
   else
     if args(0) = 3 then
       cols:= args(3);
       if not testtype(cols,Type::ListOf(Type::PosInt,1)) then
         error("expecting list of positive integers")
       end_if;
       if max(op(cols)) > op(d,2) then
         error("3nd argument: indices larger than upper matrix bound")
       end_if;
       i:= op(d,1)
     else
       i:= max(op(d))
     end_if;
     if not testtype(rows,Type::ListOf(Type::PosInt,1)) then
       error("expecting lists of positive integers")
     elif max(op(rows)) > i then
       error("2nd argument: indices larger than upper matrix bound")
     end_if;
     delete i;
   end_if
 end_if;
   
 if args(0) = 2 then
   d := A::dom::matdim(A);
   if domtype(rows) = DOM_LIST then
     if op(d,1) = 1 then
       A::dom::create( 1,nops(rows),[[A[rows[i]] $ i=1..nops(rows)]] )
     else
       A::dom::create( nops(rows),1,[A[rows[i]] $ i=1..nops(rows)] )
     end_if
   else
     A::dom::_index( A,rows )
   end_if
 else
   cols := args(3);
   if domtype(rows) = DOM_LIST then
     A::dom::create(nops(rows),nops(cols),
         [[A[rows[i],cols[j]] $ j=1..nops(cols)] $ i=1..nops(rows)]
                    )
   else
     A::dom::_index( A,rows,cols )
   end_if
 end_if
end_proc: 

