/*
    linalg::substitute( B,A,m,n )

    B, A: matrices
    m, n: positive integers

    linalg::substitute(B,A,m,n) copies the entries of the matrix A 
    into the matrix B beginning at index position [m,n], i.e.,
    B[m,n] is assigned A[1,1].
*/
linalg::substitute:= proc(B, A, m, n)
    local i, j, dA, dB, TA, TB, tmp, convert, Bcoerce;
begin
    if args(0) <> 4 then
        error("expecting four arguments")
    else
        TA:= A::dom; TB:= B::dom
    end_if;
   
    if testargs() then
        if TB::hasProp(Cat::Matrix) <> TRUE or TA::hasProp(Cat::Matrix) <> TRUE then
            error("1st and 2nd argument must be matrices of category 'Cat::Matrix'")
        end_if;
        if not testtype( m,Type::PosInt ) or not testtype( n,Type::PosInt ) then
            error("3rd and 4th arguments must be positive integers")
        end_if
    end_if;

    convert:= bool( TA::coeffRing <> TB::coeffRing);
    if convert then Bcoerce:= TB::coeffRing::coerce end;

    dA:= TA::matdim(A);
    dB:= TB::matdim(B);
    for i from 1 to dA[1] do
        if m+i-1 > dB[1] then break end;
        for j from 1 to dA[2] do
            if n+j-1 > dB[2] then break end;
            if convert then
                tmp:= Bcoerce( A[i,j] );
                if tmp = FAIL then
                    error("incompatible matrix components")
                else 
                    B[m+i-1, n+j-1]:= tmp
                end
            else
                B[m+i-1, n+j-1]:= A[i, j]
            end
        end
    end;

    return( B )
end_proc:

