/*
    linalg::sumBasis  --  returns a set of linear independent vectors
                          for the sum of vector spaces

    sumBasis(S1, S2 [,S3,...])

    S1, S2, S3 ...: list or set of vectors

    sumBasis returns a basis for the sum of the vector spaces spanned
    by the vectors in Si.
*/
linalg::sumBasis:= proc(S)
    local s, v, n, T, R;
begin
    if testargs() then
        if args(0) = 0 then error("no arguments given") end_if;

        n:= FAIL;
        for s in [args()] do
            case domtype(s)
            of DOM_LIST do
                T:= Type::ListOf; break
            of DOM_SET do
                T:= Type::SetOf; break
            otherwise
                error("expecting only sets or lists of vectors")
            end_case;

            if nops(s) = 0 then next end_if;
            v:= op(s,1);
            if not testtype(v,linalg::vectorOf(Type::AnyType)) then
                error("expecting sets or lists of vectors")
            elif n = FAIL then
                n:= nops(v);
                R:= v::dom::coeffRing;
                if not R::hasProp( Cat::Field ) then
                    error("expecting vectors over a 'Cat::Field'")
                end_if
            end_if;
            if not testtype( s,T(linalg::vectorOf(R,n)) ) then
                error("vectors are not compatible")
            end_if
        end_for
    end_if;

    if domtype(S) = DOM_SET then
        return(linalg::basis( {op( map({args()},op) )} ))
    else
        return(linalg::basis( map([args()],op) ))
    end_if
end_proc:

