/*++
  swapcol.mu

  linalg::swapCol  --  swap two columns

  swapCol( A,k,l [,b] )

  Swaps column k with column l of the matrix A.
  A range b can be given only to swap a certain part
  of both columns.
++*/

linalg::swapCol := proc(A,k,l,b)
    local c;
begin
 if testargs() then
   if args(0) < 3 or args(0) > 4 then error("expecting 3 or 4 arguments")
   elif A::dom::hasProp( Cat::Matrix ) <> TRUE then
     error("first argument is not of 'Cat::Matrix'")
   end_if;
   if not testtype( k,Type::PosInt ) or not testtype( l,Type::PosInt ) then
     error("indices must be positive integers")
   end_if;
   c:= op( A::dom::matdim(A),2 );
   if k > c or l > c then
     error("indices out of range")
   end_if;
   if args(0) = 4 then
     if type(b) <> "_range" then
       error("expecting range of positive integers")
     elif not testtype( op(b,1),Type::PosInt ) or
       not testtype( op(b,2),Type::PosInt ) then
       error("expecting range of positive integers")
     end_if;
     c:= op( A::dom::matdim(A),1 );
     if op(b,1) > c or op(b,2) > c then
       error("4th argument is out of range")
     end_if
   end_if
 end_if;
 if k = l then A 
   elif args(0) = 4 then
   if op(b,1) > op(b,2) then A
   else A::dom::swapCol(A,k,l,b)
   end_if
 else
   A::dom::swapCol(A,k,l)
 end_if
end_proc:

// end of file 
