
/*++
 linalg::symbolicInverse(M)

 -- compute the inverse of a matrix that contains many
    symbolic entries. Use Fuchssteiner's algorithm.

++*/

linalg::symbolicInverse := proc(M, subst)
local m, n, d;
begin
  [m, n]:= M::dom::matdim(M);
  if m <> n then
     error("expecting a square matrix");
  end_if;
  [M, d]:= linalg::symbolicAdjoint_Fu(M, All):
  if args(0) = 2 then
     assert(domtype(subst) = DOM_SET);
     d:= subs(d, subst, EvalChanges):
  end_if;
  if linalg::zeroTest(d) <> FALSE then
     return(FAIL);
  else
     return(map(M, _divide, d));
  end_if:
end_proc:
