/*
        linalg::vectorPotential -- computes the vector potential of 
        a vector function

        vectorPotential(x,m,[Test])

        x:    list of three expressions (the vector function)
        m:    list of three Type::Unknown's
     Test: (optional) ident

 This function determines whether the vector potential of vector 
 function 'x' exists or not. FALSE is returned if this does not exist.

 The vector potential of x exists iff the divergence of x is zero.

 If the vector potential of x exists and option 'Test' is given	
 then TRUE is returned.
 Otherwise the vector potential of 'x' is computed.
*/

linalg::vectorPotential:= proc(x,m)
    local X, t, i;
begin
    if testargs() then
        if args(0) <> 2 and args(0) <> 3 then 
            error("expecting 2 or 3 arguments")
        end_if;

        if testtype( x,linalg::vectorOf(Type::AnyType,3) ) then
            if not (x::dom::coeffRing)::hasProp( Cat::Field ) then
                error("expecting 3-dimensional vector over a 'Cat::Field'")
            end_if
        elif not testtype( x,Type::ListOf(Type::Arithmetical) ) then
            error("expecting list of arithmetical expressions")
        end_if;

        if not testtype( m,Type::ListOf(Type::Unknown,3,3 ) ) then
            error("expecting list of three (indexed) identifiers")
        end_if;

        if args(0) = 3 and args(3) <> hold(Test) then
            error("invalid option ('Test' expected)")
        end_if
    end_if;

    if not iszero( _plus( diff(x[i],m[i]) $ i=1..3 ) ) then
       return( FALSE )
    elif args(0) = 3 then 
       return( TRUE ) 
    end_if;

    t:= [NIL,NIL,0];
    X:= genident("X"); // the integration variable
    
    t[1]:= int(subs(x[2],m[3]=X),X=0..m[3]) -
    int(subs(x[3],[m[3]=0,m[2]=X]),X=0..m[2]);
    t[2]:= -int(subs(x[1],m[3]=X),X=0..m[3]);

    if domtype(x) = DOM_LIST then
        return(Dom::Matrix()( t ))
    else
        return(x::dom::coerce( t ))
    end_if
end_proc:

