// This is a utility called by the linear solvers and matrix inverters
// to test if symbolic pivot candidates are zero. This is to avoid calls 
// of normal and should be fast!

linalg::zeroTest:= x -> _lazy_or(
  iszero(x),
  testeq(x, 0, 
    Steps = 0,                  // steps in Simplify
    Seconds = infinity,         // time limit in Simplify
    hold(NumberOfRandomRatTests) = 4, // insertions identifier <-> rational numbers
    NumberOfRandomTests = 15,    //  different insertions identifier <-> numbers
    IgnoreProperties = FALSE,    // relevant for random tests + Simplify
                                // (in the random tests, use only numbers consistent 
                                //  with the properties of the identifiers?)
    hold(ZeroTestMode) = TRUE
  ));

/*  This is the version that we tried originally for R2010b:
linalg::zeroTest:= proc(x)
local r, rr, rrr, ind, y, b, var;
save SEED;
begin
  if contains({DOM_INT, DOM_RAT, DOM_COMPLEX, DOM_FLOAT, DOM_INTERVAL, DOM_POLY}, 
              domtype(x)) then
     return(iszero(x));
  end_if;
  x:= expr(x):

  // replace identifiers by random rational numbers produced by r:
  SEED:= 0;
  r:= random(1 .. 10^6)/1234567: // Expectation value ~= 0.405

  // Replace function calls such as f(x) by rrr(x) = r() + rr(x).
  //
  // Use option remember in rrr(f), to make sure that f(x) and f(y)
  // use the same value of r() (but f(x) and g(x) should produce
  // different values). (This is not really necessary here, since
  // the code below calls rrr(f) only once for each different f.)
  //
  // Use 'option remember' for rr to make sure that a subexpression
  // f(x), say, that turns up in the expression several times, is
  // replaced by the same number (but f(x) and f(y) should produce
  // different values).
  rr:= proc() option remember; option noDebug; begin r(); end_proc;
  rrr:= proc() option remember; option noDebug; begin r() + rr end_proc;

  // Eliminate some of the nasty subexpressions that may
  // raise an error when variables are replaced by positive
  // rational numbers (as produced by r()). Note that any
  // error that is raised produces an UNKNOWN in the zeroTest,
  // which the calling procedure will -probably- interpret
  // as 'this is zero', since and UNKNOWN stemming from
  // numeric::isnonzero is likely to be a 'this is zero'.

  x:= subs(x, [
    hold(int) = rrr(#Int),                         // needs symbolic entries
    hold(numeric::int) = rrr(#nInt),               // needs symbolic entries
    hold(sum) = rrr(#Sum),                         // needs symbolic entries
    hold(numeric::sum) = rrr(#nSum),               // needs symbolic entries
    hold(product) = rrr(#Product),                 // needs symbolic entries
    hold(numeric::product) = rrr(#nProduct),       // needs symbolic entries
    hold(transform::laplace) = rrr(#Laplace),      // needs symbolic entries
    hold(transform::invlaplace) = rrr(#invLaplace),// needs symbolic entries
    hold(transform::fourier) = rrr(#Fourier),      // needs symbolic entries
    hold(transform::invfourier) = rrr(#invFourier),// needs symbolic entries
    hold(transform::ztrans) = rrr(#zTrans),        // needs symbolic entries
    hold(transform::invztrans) = rrr(#invzTrans),  // needs symbolic entries
    hold(limit) = rrr(#Limit),                     // needs symbolic entries
    hold(series) = rrr(#Series),                   // needs symbolic entries
    hold(Im) = rrr(#Im),               // problem: Im(random) is always zero
    hold(Re) = rrr(#Re),               // Re(sqrt(-r())) is always zero
    hold(fact) = rrr(#Fact),           // fact(r()) throws an error
    hold(fact2) = rrr(#Fact2),         // fact2(r()) throws an error
    hold(diff) = rrr(#Diff),
    hold(D) = rrr(#D),                 // D(random number) produces zero
    hold(polylog) = rrr(#Polylog),     // polylog(n, x) wants n in N_
    hold(piecewise) = rrr(#Piecewise)  // not found by indets(expr(..),All)
  ]);
  ind:= numeric::indets(x); // use numeric::idents to catch 
                            // indexed identifiers
  if traperror((
     y:= subs(x, [(var = r()) $ var in ind], EvalChanges):
     if not contains({DOM_FLOAT, DOM_COMPLEX}, domtype(float(y))) then
      // there must be further symbolic objects such as
      // functions calls f(1/2), besselJ(0, 2/3) etc.
      // Search for the zero operands but select only
      // those where the zero operand evaluates to an
      // identifier (as opposed to funcenvs, procs etc).
      ind:= select(indets(y, All) minus Type::ConstantIdents, 
                   x -> contains({DOM_IDENT, DOM_DOMAIN}, domtype(eval(x))));
      y:= subs(y, [(var = rrr(var)) $ var in ind], EvalChanges):
     end_if:
     )) <> 0 then
     return(UNKNOWN);
  end_if:

  if traperror((b:= numeric::isnonzero(y))) = 0 then
    return(not b)
  else
    return(UNKNOWN);
  end_if:
end_proc;
*/
