//    
// sello, 12.6.97, siehe Diplomarbeit Meinolf Sellmann 1997  

/*++
decvec.mu -- compute one decreasing vector of the unbounded Tableau T associated with column l
++*/

alias(Heap=linopt::Heap):
alias(Tableau = linopt::Tableau):


    Tableau::decvec	:= 	proc(T,l)

/* Eingabe: Tableau T und Spaltenindex l
  Ausgabe: Tabelle, gibt fuer jede Variable die zugehoerige Komponente im decreasing vector an, zusaetzlich gibt
           decrvektor den Betrag an, um den die Zielfunktion sinkt, wenn man dem Vektor in voller Laenge
           folgt. Alle Werte sind schon mit einer Variablen PHI multipliziert.
*/


				local erg,ergclean,				// Ergebnis und bereinigtes Ergebnis	
				      tbl,m,n,insertedvars,equations,slackanz,
				      freevars,interval,integer,		// Tableaukomponenten			
				      i,j,					// Laufvariablen				
				      decrvektor,				// decreasing vector			
				       						// gibt fuer unbeschraenkte Ziel-	
										// funktion den konstanten Anteil	
										// an					
				      denomlcmlist,nomgcdlist,			// kgv und ggt von Nennern und Zaehlern	
				      nomgcd,denomlcm,				// Liste von Nennern und Zaehlern	
				      w,					/* rechte Seite einer Ergebnisgleichung
										  nach der Substitution freier Variablen
									          durch Null				*/
				      a;					// Bezeichner				

				begin

				  erg := {}:
				  tbl := T[1]:
				  m := T[2]:
				  n := T[3]:
				  insertedvars := T[4]:
				  equations := T[5]:
				  freevars := T[6]:
				  slackanz := T[7]:
				  interval := T[9]:
				  integer := T[12]:

				  for i from 3 to m+2 do
					if interval[tbl[i,1],"lower"] <> UNKNOWN and  interval[tbl[i,1],"greater"]
					  then erg := erg union {tbl[i,1] = tbl[i,l]}
					  else erg := erg union {tbl[i,1] = -tbl[i,l]}
					end_if
				  end_for: 

				  for j from 3 to l-1 do
				     erg := erg union {tbl[1,j] = 0}	
				  end_for:

				  if interval[tbl[1,l],"lower"] <> UNKNOWN and interval[tbl[1,l],"greater"]
				    then erg := erg union {tbl[1,j] = -1}
				    else erg := erg union {tbl[1,j] = 1}
				  end_if:

				  for j from l+1 to n+2 do
				     erg := erg union {tbl[1,j] = 0}	
				  end_for:

				  if interval[tbl[1,l],"greater"] = UNKNOWN and tbl[2,l] > 0 then
				    erg := {(op(erg,[i,1]) = -op(erg,[i,2]))$ i=1..nops(erg)}
				  end_if:


				  for i in equations do
				    if testtype(op(i,[2,nops(op(i,2))]),DOM_INT) or testtype(op(i,[2,nops(op(i,2))]),DOM_RAT)
				      then erg := erg union {op(i,1) = subs(op(i,2)-op(i,[2,nops(op(i,2))]),erg union {0.0 = 0})}
				      else erg := erg union {op(i,1) = subs(op(i,2),erg)}
				    end_if
				  end_for:

				  ergclean := {}:
				  nomgcdlist := []:
				  denomlcmlist := [1]:

				  for i from 1 to nops(erg) do
				     if not contains(insertedvars,op(erg,[i,1]))
				       then w := subs(op(erg,[i,2]),{op(freevars,j)=0$ j=1..nops(freevars)}):
					    ergclean := ergclean union 
						{op(erg,[i,1])=w}:
					    if integer[op(erg,[i,1])] then
					      nomgcdlist := append(nomgcdlist,op(w,1)):
					      if testtype(w,DOM_RAT) then
						denomlcmlist := append(denomlcmlist,op(w,2))
					      end_if
					    end_if
				     end_if
				  end_for:

				  erg := ergclean:

				  for i in (freevars minus insertedvars) do
				     erg := erg union {i=0}
			 	  end_for:

				  a := genident("PHI"):

				  if nomgcdlist = [] 
				    then nomgcd := 1
				    else nomgcd := abs(igcd(nomgcdlist[i]$ i=1..nops(nomgcdlist)))
				  end_if:

				  denomlcm := abs(ilcm(denomlcmlist[i]$ i=1..nops(denomlcmlist))):

				  for i in erg do 
				    decrvektor[op(i,1)] := op(i,2)*a*denomlcm/nomgcd
				  end_for:

				  decrvektor[linopt::objconst]:= -sign(tbl[2,l])*tbl[2,l]*a*denomlcm/nomgcd:

				  return(decrvektor)
				end_proc:

unalias(Tableau):
unalias(Heap):
