//    
// sello, 12.6.97, siehe Diplomarbeit Meinolf Sellmann 1997  

/*++
dualprice.mu -- compute the associated dualprices of the (optimal) tableau T
++*/

alias(Heap=linopt::Heap):
alias(Tableau = linopt::Tableau):



Tableau::dual_prices	:=
proc(T)

// Eingabe: optimales Tableau T
// Ausgabe: Schattenpreise, Liste von Zweitupeln bestehend aus einer
//          Restriktion und ihren Kosten

 
  
  local erg,						// Ergebnisliste			
  /*scrolls,*/slacks,				// Mengen der Scroll- und	
  /*slk,*/ 						      // Slackvariablen		
  tbl,m,n,insertedvars,equations,
  freevars,slackanz,interval,assoziated,	// Tableaukomponeneten		
  i,j;						      // Laufvariablen			
  
begin
  // slk:= table();
  erg := {}:
  tbl := T[1]:
  m := T[2]:
  n := T[3]:
  insertedvars := T[4]:
  equations := T[5]:
  freevars := T[6]:
  slackanz := T[7]:
  interval := T[9]:
  assoziated := T[10]:
  
  slacks := {hold(slk)[i]$ i=1..slackanz}:
  
  
  for j from 3 to n+2 do
    if contains(slacks,tbl[1,j])
      then if interval[tbl[1,j],"lower"] <> UNKNOWN and  interval[tbl[1,j],"greater"]
             then erg := erg union {[assoziated[tbl[1,j]],interval[tbl[1,j],"lower"]-tbl[2,j]]}
           else erg := erg union {[assoziated[tbl[1,j]],tbl[2,j]]}
           end_if
    elif contains(insertedvars,tbl[1,j])
      then if interval[tbl[1,j],"lower"] <> UNKNOWN
             then if not interval[tbl[1,j],"greater"]
                    then if assoziated[tbl[1,j]][1]=1
                           then erg := erg union
                                       {[-assoziated[tbl[1,j]][3]<=assoziated[tbl[1,j]][2],tbl[2,j]]} union
                                       {[assoziated[tbl[1,j]][2]<=
                                         interval[tbl[1,j]-assoziated[tbl[1,j]][3],"lower"],0]}
                         else erg := erg union
                                     {[-assoziated[tbl[1,j]][3]>=assoziated[tbl[1,j]][2],tbl[2,j]]} union
                                     {[assoziated[tbl[1,j]][2]>=
                                       -interval[tbl[1,j]+assoziated[tbl[1,j]][3],"lower"],0]}
                         end_if
                  elif assoziated[tbl[1,j]][1]=1
                    then erg := erg union
                                {[assoziated[tbl[1,j]][2]<=
                                  interval[tbl[1,j],"lower"]-assoziated[tbl[1,j]][3],tbl[2,j]]} union
                                {[-assoziated[tbl[1,j]][3]<=assoziated[tbl[1,j]][2],0]}
                  else erg := erg union
                              {[assoziated[tbl[1,j]][2]>=
                                -interval[tbl[1,j],"lower"]+assoziated[tbl[1,j]][3],tbl[2,j]]} union
                              {[assoziated[tbl[1,j]][3]>=assoziated[tbl[1,j]][2],0]}
                  end_if
           elif assoziated[tbl[1,j]][1]=1
             then erg := erg union
                         {[-assoziated[tbl[1,j]][3]<=assoziated[tbl[1,j]][2],tbl[2,j]]}
           else erg := erg union
                       {[assoziated[tbl[1,j]][3]>=assoziated[tbl[1,j]][2],tbl[2,j]]}
           end_if
    elif interval[tbl[1,j],"lower"] <> UNKNOWN
      then if not interval[tbl[1,j],"greater"]
             then erg := erg union {[0<=tbl[1,j],tbl[2,j]]}
                         union {[tbl[1,j]<=interval[tbl[1,j],"lower"],0]}
           else erg := erg union {[tbl[1,j]<=interval[tbl[1,j],"lower"],tbl[2,j]]}
                       union {[0<=tbl[1,j],0]}
           end_if
    elif interval[tbl[1,j],"greater"] <> UNKNOWN
      then erg := erg union {[0<=tbl[1,j],tbl[2,j]]}
    end_if
  end_for:
  
  for i from 3 to m+2 do
    if contains(slacks,tbl[i,1]) then
      if interval[tbl[i,1],"lower"] <> UNKNOWN and interval[tbl[i,1],"greater"]
        then erg := erg union {[assoziated[tbl[i,1]],interval[tbl[i,1],"lower"]]}
      else erg := erg union {[assoziated[tbl[i,1]],0]}
      end_if
    elif contains(insertedvars,tbl[i,1])
      then if interval[tbl[i,1],"lower"] <> UNKNOWN
             then if not interval[tbl[i,1],"greater"]
                    then if assoziated[tbl[i,1]][1] = 1
                           then erg := erg union
                                       {[-assoziated[tbl[i,1]][3]<=assoziated[tbl[i,1]][2],0]} union
                                       {[assoziated[tbl[i,1]][2]<=
                                         interval[tbl[i,1]-assoziated[tbl[i,1]][3],"lower"],
                                         /*interval[tbl[i,1],"lower"]-tbl[i,2]*/0]}
                         else erg := erg union
                                     {[assoziated[tbl[i,1]][3]>=assoziated[tbl[i,1]][2],0]} union
                                     {[assoziated[tbl[i,1]][2]>=
                                       -interval[tbl[i,1]+assoziated[tbl[i,1]][3],"lower"],
                                       /*interval[tbl[i,1],"lower"]-tbl[i,2]*/0]}
                         end_if
                  elif assoziated[tbl[i,1]][1] = 1
                    then erg := erg union
                                {[assoziated[tbl[i,1]][2]<=
                                  interval[tbl[i,1],"lower"]-assoziated[tbl[i,1]][3],0]} union
                                {[-assoziated[tbl[i,1]][3]<=assoziated[tbl[i,1]][2],
                                  /*interval[tbl[i,1],"lower"]-tbl[i,2]*/0]}
                  else erg := erg union
                              {[assoziated[tbl[i,1]][2]>=
                                -interval[tbl[i,1],"lower"]+assoziated[tbl[i,1]][3],0]} union
                              {[assoziated[tbl[i,1]][3]>=assoziated[tbl[i,1]][2],
                                /*interval[tbl[i,1],"lower"]-tbl[i,2]*/0]}
                  end_if
           elif assoziated[tbl[i,1]][1] = 1
             then erg := erg union
                         {[-assoziated[tbl[i,1]][3]<=assoziated[tbl[i,1]][2],0]}
           else erg := erg union
                       {[assoziated[tbl[i,1]][3]>=assoziated[tbl[i,1]][2],0]}
           end_if
    elif interval[tbl[i,1],"lower"] <> UNKNOWN
      then if not interval[tbl[i,1],"greater"]
             then erg := erg union {[0<=tbl[i,1],0]}
                         union {[tbl[i,1]<=interval[tbl[i,1],"lower"],0
                                 /*interval[tbl[i,1],"lower"]-tbl[i,2]*/]}
           else erg := erg union {[tbl[i,1]<=interval[tbl[i,1],"lower"],0]}
                       union {[0<=tbl[i,1],0
                               /*interval[tbl[i,1],"lower"]-tbl[i,2]*/]}
           end_if
    elif interval[tbl[i,1],"greater"] <> UNKNOWN
      then erg := erg union {[0<=tbl[i,1],0]}
    end_if
  end_for:
  
  return(erg)
end_proc:
unalias(Tableau):
unalias(Heap):
