//    
// sello, 12.6.97, siehe Diplomarbeit Meinolf Sellmann 1997  

/*++
dupivdeg.mu -- get blands pivot for the dual simplex method
++*/

alias(Heap=linopt::Heap):
alias(Tableau = linopt::Tableau):

Tableau::dualpivot_deg	:=	proc(tbl,m,n,interval,internalorder)


/* Eingabe: Tableaukomponenten tbl,m,n,interval,internalorder
  Ausgabe: Pivotelement [i,j,tbl[i,j],upperboundpivot]
*/


				local i,j,		// Laufvariavblen		
				      k,l,		// Pivotzeile und -spalte	
				      mini,		/* kleinster Quotient bei der
							  Bestimmung der Pivotspalte	*/
				      intervalpiv;	/* Pivotschritt um beidseitig-
							  beschraenkte Variable?	*/

				begin
        userinfo(8," Entering Tableau::dualpivot "):

				  k := 0: l := 0:
				  intervalpiv := FALSE:

				  for i from 3 to m+2 do
				    if interval[tbl[i,1],"greater"] <> UNKNOWN 
				    then if tbl[i,2] < 0  and (k = 0 or internalorder[tbl[i,1]] < internalorder[tbl[k,1]] )
					   then k := i:
						next
					 end_if: 
					 if interval[tbl[i,1],"lower"] <> UNKNOWN and interval[tbl[i,1],"lower"]-tbl[i,2] < 0 and
						(k = 0 or internalorder[tbl[i,1]] < internalorder[tbl[k,1]] )
					   then k := i 
					 end_if
				    end_if
				  end_for:

				  if k = 0 then return([k,l]) end_if:			// primal zulaessig -> fertig 

				  if tbl[k,2] >= 0 /*i > m+2*/ then 
				     intervalpiv := TRUE:

				     for j from 3 to n+2 do
				       if interval[tbl[1,j],"greater"] = UNKNOWN and tbl[k,j] <> 0
					 then return([k,j,tbl[k,j],intervalpiv])
				       end_if: 
				       if tbl[k,j] > 0
					 then mini := tbl[2,j]/tbl[k,j]:  
					      l := j:
					      break
				       end_if
				     end_for:

				     if j > n+2 then return([k,l]): end_if:		// dual unbeschraenkt -> primal leer 

				     j := j+1:
				     while (j <= n+2) do
				       if interval[tbl[1,j],"greater"] = UNKNOWN and tbl[k,j] <> 0 then
					 l := j:
					 break 
				       end_if:
				       if tbl[k,j] > 0 and ( tbl[2,j]/tbl[k,j] < mini or tbl[2,j]/tbl[k,j] = mini and
					   internalorder[tbl[1,j]] < internalorder[tbl[1,l]] ) 
					 then mini := tbl[2,j]/tbl[k,j]:  
					      l := j
				       end_if:	
				       j := j+1:					     
				     end_while:

				  else 							// normal k found 
				     for j from 3 to n+2 do
				       if interval[tbl[1,j],"greater"] = UNKNOWN and tbl[k,j] <> 0
					 then return([k,j,tbl[k,j],intervalpiv])
				       end_if:
				       if tbl[k,j] < 0 
					 then mini := -tbl[2,j]/tbl[k,j]:  
					      l := j:
					      break
				       end_if
				     end_for:

				     if j > n+2 then return([k,l]): end_if:		// dual unbeschraenkt -> primal leer 

				     j := j+1:
				     while (j <= n+2) do
				       if interval[tbl[1,j],"greater"] = UNKNOWN and tbl[k,j] <> 0 then
					 l := j:
					 break 
				       end_if:
				       if tbl[k,j] < 0 and (-tbl[2,j]/tbl[k,j] < mini or -tbl[2,j]/tbl[k,j] = mini and
					  internalorder[tbl[1,j]] < internalorder[tbl[1,l]] ) 
					 then mini := -tbl[2,j]/tbl[k,j]:  
					      l := j
				       end_if:	
				       j := j+1:
				     end_while
				  end_if:
				  return([k,l,tbl[k,l],intervalpiv]):						
				end_proc:



unalias(Tableau):
unalias(Heap):
