//    
// sello, 12.6.97, siehe Diplomarbeit Meinolf Sellmann 1997  



/*++
index.mu -- get the ith component of Tableau T
++*/

alias(Heap=linopt::Heap):
alias(Tableau = linopt::Tableau):

Tableau::_index   	:=	proc( T,i)
				begin
				  if args(0) = 3 
				  then op(T,1)[i,args(3)]
				  else op(T,i) 
				  end_if
				end_proc:

unalias(Tableau):
unalias(Heap):



/*++
indexval.mu -- 
++*/

alias(Heap=linopt::Heap):
alias(Tableau = linopt::Tableau):

Tableau::indexval   	:=	proc( T,i)
				begin
				  if args(0) = 3 
				  then (op(T,1)[i,args(3)]) 
				  else (op(T,i)) 
				  end_if
				end_proc:


unalias(Tableau):
unalias(Heap):



/*++
newtab.mu -- the datastructure of linear optimization problems
++*/

alias(Heap=linopt::Heap):
alias(Tableau = linopt::Tableau):



Tableau::new		:=	proc(liste)

/* Eingabe: Liste wie fuer ->linopt::maximize.
  Ausgabe: Erstes Tableau
  alle Optimierungen werden hier grundgelegt: implizite Behandlung beidseitig beschraenter und unbeschraenkter
  Variablen, Gleichungen, kompaktifiziertes Tableau
*/ 



				local 	tbl,				// the tableau itself, twodimensional array with 
					m,n,				// m+2 rows and n+2 columns			
					identset,			/* Set of identifiers appearing in the 
									  optimization problem	AND in the tableau	*/
					equations,			/* equations appearing in the list of 
									  restrictions					*/
					impliciteqs,			/* some equations dont need to be part of the
									  tableau - they are stored as implicit equs	*/ 
					objfct,				// the given objective function			
					scrollanz,			// number of inserted scrollvariables		
					interval,			/* table for the treatment of bounded and 
									  unbounded vars - indexed with ident, "greater"
									  or ident, "lower"				*/
					objfctscr,			// constant part of the objective function	
					/*insertedvars,*/			// scr and slk					
					integer,			// table: is ident an integer restricted var?	
					internalorder,			// order of variables               		
					identlist,		 	// list of variables        	        	
					freevars,			// set of vars not appearing in (un-)eqs 	
					inteq,				// internal (un)-equation           		
					unequations,			// set of unequations               		
					constraints,			// set of constraints               		
					gezero,				// set of unequations >= 0          		
					muneqs,mgez,			// number of unequations            		
					h,				// help variable		           		
					i,j,				// index for loops                  		
					bounded,			// sets of bounded variables        		
					allidents,			// ALL vars appearing in the given problem	
					assoziated,			// every slk-var has an assoziated restriction	
					denomlist,nomlist,		/* for tightening: list of all appearing 
									  (de)nominators in one restriction		*/
					nomgcd,denomlcm,		// lcm and gcd of the (de)nomlist		
					c,				// constant part of an equation			
					intunequ,intequ,		/* for tightening: is an (un)equation only
									  consisting of integer restricted vars?	*/
               tmpc, // temporary variable for saving a constraint       
					s;

					begin
				  /* Initialisierung von Variablen */
				  assoziated:= table();
				  integer:= table();
				  internalorder:= table();
          interval := table();

        userinfo(6," Entering Tableau Constructor "):


				    if args(0) <> 1  then 
					error("One list with set of (un)-equations and an objective function expected")
				    end_if:


				    if (nops(liste) < 2) or (nops(liste) > 4)					// input list ok? 
				    then error("List with set of (un)-equations and an objective function expected")
				    end_if: 

				    if not testtype(op(liste,1),DOM_SET) 
				    then if not testtype(op(liste,1),DOM_LIST)  
					   then error("Set of (un)-equations expected")
					   else liste[1] := {liste[1][i]$ i=1..nops(liste[1])}
					 end_if
				    end_if:

				    objfct := numeric::rationalize(op(liste,2), Minimize):

				    if (domtype(objfct) <> DOM_EXPR) and (domtype(objfct) <> DOM_IDENT) and not 
					(testtype(objfct,DOM_INT) or testtype(objfct,DOM_FLOAT) or testtype(objfct,DOM_RAT))
				    then error("No correct objective function specified")
				    end_if:

				    if nops(liste) >= 3 then 
					if testtype(op(liste,3),DOM_SET)
					then for i from 1 to nops(op(liste,3)) do
					       if not testtype(op(liste,[3,i]),DOM_IDENT) then
						 error("Set of nonnegative variables expected")
					       end_if:
					     end_for
					elif (op(liste,3) <> NonNegative) then 
					    error("Set of nonnegative variables expected") 
					end_if: 

					if nops(liste) = 4 then
					  if testtype(op(liste,4),DOM_SET)
					    then for i from 1 to nops(op(liste,4)) do
					           if not testtype(op(liste,[4,i]),DOM_IDENT) then
						     error("Set of integer variables expected")
					           end_if
					         end_for
					    elif (op(liste,4) <> All) then 
					        error("Set of integer variables expected") 
					    end_if
					end_if
				     end_if:

				    unequations := {}:
				    equations := {}:
				    impliciteqs := {}:
				    gezero := {}:
				    constraints := numeric::rationalize(op(liste,1), Minimize):

				    identset :={}:
				    allidents := indets(constraints) union indets(objfct):
				    freevars := allidents:

				    if nops(liste) = 3 
				      then if testtype(op(liste,3),DOM_SET) 
					     then for i in op(liste,3) do
						    interval[i,"greater"] := 0:
						    interval[i,"lower"] := UNKNOWN:
						    integer[i] := FALSE
						  end_for:
						  for i in allidents minus op(liste,3) do
						    interval[i,"greater"] := UNKNOWN:
						    interval[i,"lower"] := UNKNOWN:
						    integer[i] := FALSE
						  end_for
					     else for i in allidents do
						    interval[i,"greater"] := 0:
						    interval[i,"lower"] := UNKNOWN:
						    integer[i] := FALSE
						  end_for
					   end_if
				      elif nops(liste) = 4
					  then if testtype(op(liste,3),DOM_SET) 
					         then if testtype(op(liste,4),DOM_SET)
						        then for i in op(liste,3) do
						               interval[i,"greater"] := 0:
						               interval[i,"lower"] := UNKNOWN
						             end_for:
						             for i in allidents minus op(liste,3) do
						               interval[i,"greater"] := UNKNOWN:
						               interval[i,"lower"] := UNKNOWN
						             end_for:
						             for i in op(liste,4) do
						               integer[i] := TRUE
						             end_for:
						    	     for i in allidents minus op(liste,4) do
						               integer[i] := FALSE
						             end_for
						        else for i in op(liste,3) do
						               interval[i,"greater"] := 0:
						               interval[i,"lower"] := UNKNOWN:
							       integer[i] := TRUE
						             end_for:
						             for i in allidents minus op(liste,3) do
						               interval[i,"greater"] := UNKNOWN:
						               interval[i,"lower"] := UNKNOWN:
							       integer[i] := TRUE
						             end_for
						      end_if
					         elif testtype(op(liste,4),DOM_SET)
						        then for i in op(liste,4) do
						               integer[i] := TRUE:
							       interval[i,"greater"] := 0:
						               interval[i,"lower"] := UNKNOWN
						             end_for:
						    	     for i in allidents minus op(liste,4) do
						               integer[i] := FALSE:
							       interval[i,"greater"] := 0:
						               interval[i,"lower"] := UNKNOWN
						             end_for
						        else for i in allidents do
						               integer[i] := TRUE:
							       interval[i,"greater"] := 0:
						               interval[i,"lower"] := UNKNOWN
						             end_for
					       end_if
					  else for i in allidents do
						 integer[i] := FALSE:
						 interval[i,"greater"] := UNKNOWN:
						 interval[i,"lower"] := UNKNOWN
					       end_for
				    end_if: 						



//***********************************************************************************************************************************************************


				    bounded := {}:

				    i := 1:
				    while i <= nops(constraints) do 					 /* search for x with
													   a <= x or x <= b */
					case type(op(constraints,i)) 
					of "_leequal" do
					     inteq := op(constraints,[i,1])-op(constraints,[i,2]):
//inteq := subs (inteq,equations):

					     if testtype(inteq,"_plus") and (nops(inteq) = 2)  
					     then if ( testtype(op(inteq,2),DOM_INT  ) or
						       testtype(op(inteq,2),DOM_RAT  ) ) and 
						     ( testtype(op(inteq,1),DOM_IDENT) or
						       testtype(op(inteq,1),"_mult") )
						  then if testtype(op(inteq,1),"_mult")
						       then if ( testtype(op(inteq,[1,2]),DOM_INT  ) or 
								 testtype(op(inteq,[1,2]),DOM_RAT  ) ) and 
								 testtype(op(inteq,[1,1]),DOM_IDENT)
							    then if op(inteq,[1,2]) < 0 
								 then if interval[op(inteq,[1,1]),"greater"] <> UNKNOWN
								      then if interval[op(inteq,[1,1]),"greater"] < -op(inteq,2)/op(inteq,[1,2])
									   then	if integer[op(inteq,[1,1])]
										  then interval[op(inteq,[1,1]),"greater"] := 
											ceil(-op(inteq,2)/op(inteq,[1,2]))
										  else interval[op(inteq,[1,1]),"greater"] := 
											-op(inteq,2)/op(inteq,[1,2])
										end_if:
										bounded := bounded union {op(inteq,[1,1])}
									   end_if
								      else if integer[op(inteq,[1,1])] 
									     then interval[op(inteq,[1,1]),"greater"] := ceil(-op(inteq,2)/op(inteq,[1,2]))
									     else interval[op(inteq,[1,1]),"greater"] := -op(inteq,2)/op(inteq,[1,2])
									   end_if:
									   bounded := bounded union {op(inteq,[1,1])}
								      end_if
								 elif interval[op(inteq,[1,1]),"lower"] <> UNKNOWN
								      then if interval[op(inteq,[1,1]),"lower"] > -op(inteq,2)/op(inteq,[1,2])
									   then if integer[op(inteq,[1,1])]
										  then interval[op(inteq,[1,1]),"lower"] := floor(-op(inteq,2)/op(inteq,[1,2]))
										  else interval[op(inteq,[1,1]),"lower"] := -op(inteq,2)/op(inteq,[1,2])
										end_if:
										bounded := bounded union {op(inteq,[1,1])}
									   end_if
								      else if integer[op(inteq,[1,1])]
									     then interval[op(inteq,[1,1]),"lower"] := floor(-op(inteq,2)/op(inteq,[1,2]))
									     else interval[op(inteq,[1,1]),"lower"] := -op(inteq,2)/op(inteq,[1,2])
									   end_if:
									   bounded := bounded union {op(inteq,[1,1])}
								 end_if
							    else 
								 error("Linear optimization only!")
							    end_if
						       else if interval[op(inteq,1),"lower"] <> UNKNOWN
							    then if interval[op(inteq,1),"lower"] > -op(inteq,2)
								 then if integer[op(inteq,1)]
									then interval[op(inteq,1),"lower"] := floor(-op(inteq,2))
									else interval[op(inteq,1),"lower"] := -op(inteq,2)
								      end_if:
								      bounded := bounded union {op(inteq,1)}
								 end_if
							    else if integer[op(inteq,1)] 
								   then interval[op(inteq,1),"lower"] := floor(-op(inteq,2))
								   else interval[op(inteq,1),"lower"] := -op(inteq,2)
								 end_if:
								 bounded := bounded union {op(inteq,1)} 
							    end_if
						       end_if
						  else i := i+1: break
						  end_if
					     elif testtype(inteq,"_mult")
					       then if ( testtype(op(inteq,2),DOM_INT  ) or 
							 testtype(op(inteq,2),DOM_RAT  ) ) and 
							 testtype(op(inteq,1),DOM_IDENT)
						    then if op(inteq,2) < 0 
							 then if interval[op(inteq,1),"greater"] <> UNKNOWN
							      then if interval[op(inteq,1),"greater"] < 0
								   then	interval[op(inteq,1),"greater"] := 0:
									bounded := bounded union {op(inteq,1)}
								   end_if
							      else interval[op(inteq,1),"greater"] := 0:
								   bounded := bounded union {op(inteq,1)}
							      end_if
							 elif interval[op(inteq,1),"lower"] <> UNKNOWN
							   then if interval[op(inteq,1),"lower"] > 0
								then interval[op(inteq,1),"lower"] := 0:
								     bounded := bounded union {op(inteq,1)}
								end_if
							   else interval[op(inteq,1),"lower"] := 0:
								bounded := bounded union {op(inteq,1)}
							 end_if:
						    else 
							 error("Linear optimization only!")
						    end_if
						elif testtype(inteq,DOM_IDENT)
						  then if interval[inteq,"lower"] <> UNKNOWN
						       then if interval[inteq,"lower"] > 0 then
							      interval[inteq,"lower"] := 0:
							      bounded := bounded union {inteq}
							    end_if
						       else interval[inteq,"lower"] := 0:
							    bounded := bounded union {inteq} 
						       end_if
						   elif ( testtype(inteq,DOM_INT  ) or 
							 testtype(inteq,DOM_RAT  ) )
						      then if inteq > 0 then return(Tableau::empty()) end_if
						      else i := i+1: break
					     end_if:

					     constraints := constraints minus {op(constraints,i)}:

					     break
					of "_equal" do
					     i := i+1: 
					     break
					otherwise 
					     error("Set of (un)-equations expected"):
					     break
					end_case
				    end_while:  							// a <= x <= b 

				    j := 1:								/* insert scrolling vars 
													  for [b >=] x >= a :-> 
													  [b-a >=] y = x-a >= 0 */
				    for i in bounded do

				      if interval[i,"greater"] <> UNKNOWN 
					then if interval[i,"greater"] <> 0
					       then if interval[i,"lower"] <> UNKNOWN then
						      if interval[i,"greater"] > interval[i,"lower"] 
							then return(Tableau::empty()) 
						      end_if:

						      if interval[i,"greater"] = interval[i,"lower"]
						      then if not integer[i] or testtype(interval[i,"greater"],DOM_INT)
							     then equations := subs(equations,{i=interval[i,"greater"]}) 
									union {i=interval[i,"greater"]}
							     else return(Tableau::empty())
							   end_if:
							   next
						      end_if:

						      interval[linopt::scr[j],"greater"] := 0:
						      interval[linopt::scr[j],"lower"] := interval[i,"lower"]-interval[i,"greater"]:
						      integer[linopt::scr[j]] := integer[i]:

						      equations := subs(equations,{i=linopt::scr[j]+interval[i,"greater"]}) union 
									 {i=linopt::scr[j]+interval[i,"greater"]}:
						      if testtype(assoziated[i],"_index") then
							    assoziated[linopt::scr[j]] := [1,i,-interval[i,"greater"]]
						      else 
							    assoziated[linopt::scr[j]] := [assoziated[i][1],assoziated[i][2], assoziated[i][3]-interval[i,"greater"]]
						      end_if: 
						      j := j+1:
						      next
						    end_if:
						    interval[linopt::scr[j],"greater"] := 0:
						    interval[linopt::scr[j],"lower"] := UNKNOWN:
						    integer[linopt::scr[j]] := integer[i]:

						    equations := subs(equations,{i=linopt::scr[j]+interval[i,"greater"]}) 
								 union {i=linopt::scr[j]+interval[i,"greater"]}:
						    if testtype(assoziated[i],"_index")
						      then assoziated[linopt::scr[j]] := [1,i,-interval[i,"greater"]]
						      else assoziated[linopt::scr[j]] := [assoziated[i][1],assoziated[i][2],
										       assoziated[i][3]-interval[i,"greater"]]
						    end_if:							
						    j := j+1
					       elif interval[i,"lower"] <> UNKNOWN then
						   if 0 > interval[i,"lower"] then return(Tableau::empty()) end_if:
						   if 0 = interval[i,"lower"]
						   then equations := subs(equations,{i=0}) union {i=0}
						   end_if
					     end_if
					else interval[linopt::scr[j],"greater"] := 0:
					     interval[linopt::scr[j],"lower"] := UNKNOWN:
					     integer[linopt::scr[j]] := integer[i]:
					     equations := subs(equations,{i=-linopt::scr[j]+interval[i,"lower"]}) union {i=-linopt::scr[j]+interval[i,"lower"]}:
					     if testtype(assoziated[i],"_index")
					       then assoziated[linopt::scr[j]] := [-1,i,interval[i,"lower"]]
					       else assoziated[linopt::scr[j]] := [-assoziated[i][1],assoziated[i][2],
									       -assoziated[i][3]-interval[i,"lower"]]
					     end_if:
					     j := j+1
				      end_if 
				    end_for:

				    scrollanz := j-1:
				    bounded := {}:

//***********************************************************************************************************************************************************


				    i := 1:
				    while i <= nops(constraints) do					/* build internal set of
													  equations */ 
					if testtype(op(constraints,i),"_leequal") 
					then i := i+1: next end_if:


					     inteq := op(constraints,[i,1])-op(constraints,[i,2]):
					     inteq := subs(inteq,equations):
					     h := FALSE:
					     c := 0:
					     nomlist := []:
					     denomlist := [1]:
					     intequ := TRUE:

					     if testtype(inteq,"_plus") 				/* test all operands of 
													  the equation */
					     then for j from 1 to nops(inteq) do			
						    if testtype(op(inteq,j),"_mult") 
						    then if ( testtype(op(inteq,[j,2]),DOM_INT  ) or
							      testtype(op(inteq,[j,2]),DOM_RAT  ) ) and 
							    ( testtype(op(inteq,[j,1]),DOM_IDENT) or
							      testtype(op(inteq,[j,1]),"_index") ) 
							  then if interval[op(inteq,[j,1]),"greater"] = UNKNOWN and not integer[op(inteq,[j,1])]
							       then h := [op(inteq,[j,1]),-op(inteq,[j,2])]:
								    intequ := FALSE:
								    break:
							       else nomlist := append(nomlist,op(op(inteq,[j,2]),1)):
								    if testtype(op(inteq,[j,2]),DOM_RAT) then
								      denomlist := append(denomlist,op(op(inteq,[j,2]),2))
								    end_if:
								    intequ := intequ and integer[op(inteq,[j,1])]:
								    if (h = FALSE) then
								      h := [op(inteq,[j,1]),-op(inteq,[j,2])]
								    end_if
							       end_if
							  else 
							       error("Linear optimization only!")
							  end_if
						    elif testtype(op(inteq,j),DOM_IDENT) or testtype(op(inteq,j),"_index")
						      then if interval[op(inteq,j),"greater"] = UNKNOWN and not integer[op(inteq,j)]
							    then h := [op(inteq,j),-1]:
								 intequ := FALSE:
								 break:
							    else nomlist := [1]:
								 intequ := intequ and integer[op(inteq,j)]:
								 if (h = FALSE) then
								   h := [op(inteq,j),-1]
								 end_if
							    end_if
						      elif not ( testtype(op(inteq,j),DOM_INT  ) or 
								 testtype(op(inteq,j),DOM_RAT  ) )
							then 
							     error("Linear optimization only!")
							else c := op(inteq,j)
						    end_if:
						  end_for
					     elif testtype(inteq,"_mult") 
					       then if ( testtype(op(inteq,2),DOM_INT  ) or 
							 testtype(op(inteq,2),DOM_RAT  ) ) and 
						       ( testtype(op(inteq,1),DOM_IDENT) or 
							 testtype(op(inteq,1),"_index") )
						    then intequ := FALSE:
							 h := [op(inteq,1),-op(inteq,2)]
						    else 
							 error("Linear optimization only!")
						    end_if
					       elif testtype(inteq,DOM_IDENT) or testtype(inteq,"_index") 
						 then intequ := FALSE:
						      h := [inteq,-1]
						 elif not ( testtype(inteq,DOM_INT  ) or 
							    testtype(inteq,DOM_RAT  ) )
						   then 
							error("Linear optimization only!")
					     end_if:

					     if h = FALSE
					     then if bool(inteq <> 0) then return(Tableau::empty()) end_if

					     else inteq := subs(inteq + h[2]*h[1],0.0=0):

						  if intequ and 
						    not testtype(c*ilcm(denomlist[i]$ i=1..nops(denomlist))/igcd(nomlist[i]$ i=1..nops(nomlist)),DOM_INT) then 
						    return(Tableau::empty())
						  end_if:

						  if interval[h[1],"greater"] <> UNKNOWN or integer[h[1]]
						    then if testtype(inteq,DOM_INT  ) or 
							    testtype(inteq,DOM_RAT  ) 
							   then if ( interval[h[1],"lower"] <> UNKNOWN  and 
									  inteq/h[2] > interval[h[1],"lower"] or
								     interval[h[1],"greater"] <> UNKNOWN and inteq/h[2] < 0) or
								     integer[h[1]] and not testtype(inteq/h[2],DOM_INT  )
								   then return(Tableau::empty())
								   else interval[h[1],"greater"] := inteq/h[2]:
									interval[h[1],"lower"] := inteq/h[2]:
									bounded := bounded union {h[1]}:
                           tmpc := op(constraints,i) ;
									constraints := constraints minus {op(constraints,i)}:
                           constraints := subs(constraints, tmpc);
								        next
								 end_if
							   else impliciteqs := impliciteqs union {h[1]}:
								gezero := gezero union {h[1]=inteq/h[2]}:
								identset := identset union indets(inteq,PolyExpr)
							 end_if
						  end_if:
						  equations := {op(equations,[i,1]) = subs(op(equations,[i,2]),h[1]=inteq/h[2])
								$ i=1..nops(equations)} union {h[1]=inteq/h[2]}:
						  identset := identset minus {h[1]}:
						  gezero := {op(gezero,[i,1]) = subs(op(gezero,[i,2]),h[1]=inteq/h[2])
							       $ i=1..nops(gezero)}:
					     end_if:

					     constraints := constraints minus {op(constraints,i)}:
													// equations 
				    end_while:


//***********************************************************************************************************************************************************



				    j := scrollanz + 1:

				    i := 1:
				    while i <= nops(constraints) do 					 /* search for x with
													   a <= x or x <= b */
					case type(op(constraints,i)) 
					of "_leequal" do
					     inteq := op(constraints,[i,1])-op(constraints,[i,2]):
					     inteq := subs (inteq,equations):

					     if testtype(inteq,"_plus") and (nops(inteq) = 2)  
					     then if ( testtype(op(inteq,2),DOM_INT  ) or 
						       testtype(op(inteq,2),DOM_RAT  ) ) and 
						     ( testtype(op(inteq,1),DOM_IDENT) or
						       testtype(op(inteq,1),"_mult") )
						  then if testtype(op(inteq,1),"_mult")
						       then if ( testtype(op(inteq,[1,2]),DOM_INT  ) or 
								 testtype(op(inteq,[1,2]),DOM_RAT  ) ) and 
								 testtype(op(inteq,[1,1]),DOM_IDENT)
							    then if op(inteq,[1,2]) < 0 
								 then if interval[op(inteq,[1,1]),"greater"] <> UNKNOWN
								      then if interval[op(inteq,[1,1]),"greater"] < -op(inteq,2)/op(inteq,[1,2])
									   then	if integer[op(inteq,[1,1])]
										   then interval[op(inteq,[1,1]),"greater"] := 
											ceil(-op(inteq,2)/op(inteq,[1,2]))
										   else interval[op(inteq,[1,1]),"greater"] := 
											-op(inteq,2)/op(inteq,[1,2])
										end_if:
										bounded := bounded union {op(inteq,[1,1])}
									   end_if
								      else if integer[op(inteq,[1,1])]
									     then interval[op(inteq,[1,1]),"greater"] := ceil(-op(inteq,2)/op(inteq,[1,2]))
									     else interval[op(inteq,[1,1]),"greater"] := -op(inteq,2)/op(inteq,[1,2])
									   end_if:
									   bounded := bounded union {op(inteq,[1,1])}
								      end_if
								 elif interval[op(inteq,[1,1]),"lower"] <> UNKNOWN
								      then if interval[op(inteq,[1,1]),"lower"] > -op(inteq,2)/op(inteq,[1,2])
									   then if integer[op(inteq,[1,1])]
										  then interval[op(inteq,[1,1]),"lower"] := floor(-op(inteq,2)/op(inteq,[1,2]))
										  else interval[op(inteq,[1,1]),"lower"] := -op(inteq,2)/op(inteq,[1,2])
										end_if:
										bounded := bounded union {op(inteq,[1,1])}
									   end_if
								      else if integer[op(inteq,[1,1])]
									     then interval[op(inteq,[1,1]),"lower"] := floor(-op(inteq,2)/op(inteq,[1,2]))
									     else interval[op(inteq,[1,1]),"lower"] := -op(inteq,2)/op(inteq,[1,2])
									   end_if:
									   bounded := bounded union {op(inteq,[1,1])}
								 end_if
							    else 
								 error("Linear optimization only!")
							    end_if
						       else if interval[op(inteq,1),"lower"] <> UNKNOWN
							    then if interval[op(inteq,1),"lower"] > -op(inteq,2)
								 then if integer[op(inteq,1)] 
									then interval[op(inteq,1),"lower"] := floor(-op(inteq,2))
									else interval[op(inteq,1),"lower"] := -op(inteq,2)
								      end_if:
								      bounded := bounded union {op(inteq,1)} 
								 end_if
							    else if integer[op(inteq,1)] 
								   then interval[op(inteq,1),"lower"] := floor(-op(inteq,2))
								   else interval[op(inteq,1),"lower"] := -op(inteq,2)
								 end_if:
								 bounded := bounded union {op(inteq,1)} 
							    end_if
						       end_if
						  else i := i+1: break
						  end_if
					     elif testtype(inteq,"_mult")
					       then if ( testtype(op(inteq,2),DOM_INT  ) or 
							 testtype(op(inteq,2),DOM_RAT  ) ) and 
							 testtype(op(inteq,1),DOM_IDENT)
						    then if op(inteq,2) < 0 
							 then if interval[op(inteq,1),"greater"] <> UNKNOWN
							      then if interval[op(inteq,1),"greater"] < 0
								   then	interval[op(inteq,1),"greater"] := 0:
									bounded := bounded union {op(inteq,1)}
								   end_if
							      else interval[op(inteq,1),"greater"] := 0:
								   bounded := bounded union {op(inteq,1)}
							      end_if
							 elif interval[op(inteq,1),"lower"] <> UNKNOWN
							   then if interval[op(inteq,1),"lower"] > 0
								then interval[op(inteq,1),"lower"] := 0:
								     bounded := bounded union {op(inteq,1)}
								end_if
							   else interval[op(inteq,1),"lower"] := 0:
								bounded := bounded union {op(inteq,1)}
							 end_if:
						    else 
							 error("Linear optimization only!")
						    end_if
						elif testtype(inteq,DOM_IDENT)
						  then if interval[inteq,"lower"] <> UNKNOWN
						       then if interval[inteq,"lower"] > 0 then
							      interval[inteq,"lower"] := 0:
							      bounded := bounded union {inteq}
							    end_if
						       else interval[inteq,"lower"] := 0:
							    bounded := bounded union {inteq} 
						       end_if
						   elif ( testtype(inteq,DOM_INT  ) or 
							 testtype(inteq,DOM_RAT  ) )
						      then if inteq > 0 then return(Tableau::empty()) end_if
						      else i := i+1: break
					     end_if:

					     constraints := constraints minus {op(constraints,i)}:

					     break
					of "_equal" do
					     i := i+1: 
					     break
					otherwise 
					     error("Set of (un)-equations expected"):
					     break
					end_case:

				    end_while:  							// a <= x <= b 

													/* insert scrolling vars 
													  for [b >=] x >= a :-> 
													  [b-a >=] y = x-a >= 0 */
				    for i in bounded do

				      if interval[i,"greater"] <> UNKNOWN 
					then if interval[i,"greater"] <> 0
					       then if interval[i,"lower"] <> UNKNOWN then
						      if interval[i,"greater"] > interval[i,"lower"] 
							then return(Tableau::empty()) 
						      end_if:

						      if interval[i,"greater"] = interval[i,"lower"]
						      then if not integer[i] or testtype(interval[i,"greater"],DOM_INT)
							     then equations := {(op(equations,[s,1]) = 
							           subs(op(equations,[s,2]),{i=interval[i,"greater"]}))$ s=1..nops(equations)}
									union {i=interval[i,"greater"]}:
						                  identset := identset minus {i}:
						                  gezero := {op(gezero,[s,1]) = subs(op(gezero,[s,2]),{i=interval[i,"greater"]})
							                   $ s=1..nops(gezero)}
							     else return(Tableau::empty())
							   end_if:
							   next
						      end_if:

						      interval[linopt::scr[j],"greater"] := 0:
						      interval[linopt::scr[j],"lower"] := interval[i,"lower"]-interval[i,"greater"]:
						      integer[linopt::scr[j]] := integer[i]:

						      equations := {(op(equations,[s,1]) = 
							subs(op(equations,[s,2]),{i=linopt::scr[j]+interval[i,"greater"]}))$ s=1..nops(equations)} union 
									 {i=linopt::scr[j]+interval[i,"greater"]}:

						      if contains(identset,i) then
							identset := (identset union {linopt::scr[j]}) minus {i}
						      end_if:
							
						      gezero := {op(gezero,[s,1]) = subs(op(gezero,[s,2]),{i=linopt::scr[j]+interval[i,"greater"]})
							              $ s=1..nops(gezero)}:
						      if testtype(assoziated[i],"_index")
							then assoziated[linopt::scr[j]] := [1,i,-interval[i,"greater"]]
							else assoziated[linopt::scr[j]] := [assoziated[i][1],assoziated[i][2],
										       assoziated[i][3]-interval[i,"greater"]]
						      end_if: 
						      j := j+1:
						      next
						    end_if:
						    interval[linopt::scr[j],"greater"] := 0:
						    interval[linopt::scr[j],"lower"] := UNKNOWN:
						    integer[linopt::scr[j]] := integer[i]:
						    equations := {(op(equations,[s,1]) = 
							subs(op(equations,[s,2]),{i=linopt::scr[j]+interval[i,"greater"]}))$ s=1..nops(equations)}
								 union {i=linopt::scr[j]+interval[i,"greater"]}:
						    if contains(identset,i) then
						      identset := (identset union {linopt::scr[j]}) minus {i}
						    end_if:
						    gezero := {op(gezero,[s,1]) = subs(op(gezero,[s,2]),{i=linopt::scr[j]+interval[i,"greater"]})
							              $ s=1..nops(gezero)}:
						    if testtype(assoziated[i],"_index")
						      then assoziated[linopt::scr[j]] := [1,i,-interval[i,"greater"]]
						      else assoziated[linopt::scr[j]] := [assoziated[i][1],assoziated[i][2],
										       assoziated[i][3]-interval[i,"greater"]]
						    end_if:							
						    j := j+1
					       elif interval[i,"lower"] <> UNKNOWN then
						   if 0 > interval[i,"lower"] then return(Tableau::empty()) end_if:
						   if 0 = interval[i,"lower"]
						   then equations := {(op(equations,[s,1]) = 
							   subs(op(equations,[s,2]),{i=0}))$ s=1..nops(equations)} union {i=0}:
						        identset := identset minus {i}:
						        gezero := {op(gezero,[s,1]) = subs(op(gezero,[s,2]),{i=0})
							              $ s=1..nops(gezero)}:
						   end_if
					     end_if
					else interval[linopt::scr[j],"greater"] := 0:
					     interval[linopt::scr[j],"lower"] := UNKNOWN:
					     integer[linopt::scr[j]] := integer[i]:
					     equations := {(op(equations,[s,1]) = 
							subs(op(equations,[s,2]),{i=-linopt::scr[j]+interval[i,"lower"]}))$ s=1..nops(equations)}
								union {i=-linopt::scr[j]+interval[i,"lower"]}:
					     if contains(identset,i) then
					       identset := (identset union {linopt::scr[j]}) minus {i}
					     end_if:
					     gezero := {op(gezero,[s,1]) = subs(op(gezero,[s,2]),{i=-linopt::scr[j]+interval[i,"lower"]})
							              $ s=1..nops(gezero)}:
					     if testtype(assoziated[i],"_index")
					       then assoziated[linopt::scr[j]] := [-1,i,interval[i,"lower"]]
					       else assoziated[linopt::scr[j]] := [-assoziated[i][1],assoziated[i][2],
									       -assoziated[i][3]-interval[i,"lower"]]
					     end_if:
					     j := j+1
				      end_if 
				    end_for:

				    scrollanz := j-1:


//***********************************************************************************************************************************************************



				    i := 1:
				    while i <= nops(constraints) do					/* build internal set of
													  unequations */ 

					     inteq := op(constraints,[i,1])-op(constraints,[i,2]):
					     inteq := subs (inteq,equations):

					     h := 0:
					     nomlist := []:
					     denomlist := [1]:
					     intunequ := TRUE:	

					     if testtype(inteq,"_plus")
					     then for j from 1 to nops(inteq) do			/* test all operands of 
													  the unequation */
						    if testtype(op(inteq,j),"_mult") 
						    then if ( testtype(op(inteq,[j,2]),DOM_INT  ) or 
							      testtype(op(inteq,[j,2]),DOM_RAT  ) ) and 
							    ( testtype(op(inteq,[j,1]),DOM_IDENT) or 
							      testtype(op(inteq,[j,1]),"_index") )
							 then intunequ := intunequ and integer[op(inteq,[j,1])]:
							      nomlist := append(nomlist,op(op(inteq,[j,2]),1)):
							      if testtype(op(inteq,[j,2]),DOM_RAT) then
								denomlist := append(denomlist,op(op(inteq,[j,2]),2))
							      end_if:
							      identset := identset union {op(inteq,[j,1])}
							 else 
							      error("Linear optimization only!")
							 end_if
						    elif ( testtype(op(inteq,j),DOM_INT  ) or 
							   testtype(op(inteq,j),DOM_RAT  ) )
						      then h := op(inteq,j)
						      elif ( testtype(op(inteq,j),DOM_IDENT) or 
							     testtype(op(inteq,j),"_index") ) 
							then nomlist := [1]:
							     intunequ := intunequ and integer[op(inteq,j)]:
							     identset := identset union {op(inteq,j)} 
							else 
							     error("Linear optimization only!")
						    end_if:
						  end_for
					     elif testtype(inteq,"_mult") 
					       then if ( testtype(op(inteq,2),DOM_INT  ) or 
							 testtype(op(inteq,2),DOM_RAT  ) ) and 
						       ( testtype(op(inteq,1),DOM_IDENT) or 
							 testtype(op(inteq,1),"_index") )
						    then nomlist := append(nomlist,op(op(inteq,2),1)):
							 if testtype(op(inteq,2),DOM_RAT) then
							   denomlist := append(denomlist,op(op(inteq,2),2))
							 end_if:
							 intunequ := intunequ and integer[op(inteq,1)]:
							 identset := identset union {op(inteq,1)}
						    else 
							 error("Linear optimization only!")
						    end_if
					       elif ( testtype(inteq,DOM_INT  ) or 
						      testtype(inteq,DOM_RAT  ) )
						 then h := inteq
						 elif ( testtype(inteq,DOM_IDENT) or 
							testtype(inteq,"_index") ) 
						   then nomlist := [1]:
							intunequ := intunequ and integer[inteq]:
						        identset := identset union {inteq} 
						   else 
							error("Linear optimization only!")
					     end_if:

					     if not ( testtype(inteq,DOM_IDENT) or testtype(inteq,"_index") or testtype(inteq,DOM_EXPR))
					     then if bool(inteq > 0)					// -h ?????? 
						  then return(Tableau::empty())
						  end_if:
					     else inteq := subs(inteq - h,0.0=0):
						  if intunequ then
						    nomgcd := abs(igcd(nomlist[i]$ i=1..nops(nomlist))):
						    denomlcm := abs(ilcm(denomlist[i]$ i=1..nops(denomlist))):
						    h := ceil(h*denomlcm/nomgcd)*nomgcd/denomlcm
						  end_if:
						  unequations := unequations union {[inteq,-h,i]}
					     end_if:

					i := i+1
				    end_while:								// unequations 


//***********************************************************************************************************************************************************


				    objfct := subs(objfct,equations):
				    objfctscr := 0:

				    if testtype(objfct,"_plus")
				    then for j from 1 to nops(op(objfct)) do				/* test all operands of 
													  the objective function */

					   if testtype(op(objfct,j),"_mult") 				// _mult(x,i) in Tableau order ! 
					   then if ( testtype(op(objfct,[j,2]),DOM_INT  ) or  
						     testtype(op(objfct,[j,2]),DOM_RAT  ) ) and 
						   ( testtype(op(objfct,[j,1]),DOM_IDENT) or
						     testtype(op(objfct,[j,1]),"_index") )
						then identset := identset union {op(objfct,[j,1])}
						else error("Linear optimization only!")
						end_if
					   elif testtype(op(objfct,j),DOM_IDENT) or testtype(op(objfct,j),"_index")
					     then identset := identset union {op(objfct,j)}:
					     elif not (testtype(op(objfct,j),DOM_INT  ) or  
						       testtype(op(objfct,j),DOM_RAT  ))
						then error("Linear optimization only!")
						else objfctscr := op(objfct,j)
					   end_if:
				       end_for
				    elif testtype(objfct,"_mult") 					// _mult(x,i) in Tableau order ! 
				      then if ( testtype(op(objfct,2),DOM_INT  ) or  
						testtype(op(objfct,2),DOM_RAT  ) ) and 
					      ( testtype(op(objfct,1),DOM_IDENT) or
						testtype(op(objfct,1),"_index") )
					   then identset := identset union {op(objfct,1)}
					   else error("Linear optimization only!")
					   end_if
				      elif ( testtype(objfct,DOM_IDENT) or testtype(objfct,"_index") )
					then identset := identset union {objfct}:
					elif not (testtype(objfct,DOM_INT  ) or  
						  testtype(objfct,DOM_RAT  ))
					  then error("Linear optimization only!")
					  else objfctscr := objfct

				    end_if;							// test of the an objective function 



//***********************************************************************************************************************************************************
//***********************************************************************************************************************************************************



				  n := nops(identset):

				  freevars := (freevars union {linopt::scr[i]$ i=1..scrollanz}) minus 
						(identset union {op(equations,[i,1])$ i=1..nops(equations)}):

				  identlist := [op(identset,i)$ i=1..n]:

				  i := 1:
				  while i <= nops(gezero) do					 	
					if not (testtype(op(gezero,[i,2]),"_plus") or
						testtype(op(gezero,[i,2]),"_mult") or
						testtype(op(gezero,[i,2]),DOM_IDENT) or 
						testtype(op(gezero,[i,2]),"_index") )
					then if nops(liste) >= 3
					     then if testtype(op(liste,3),DOM_SET)
						  then if contains(op(liste,3),op(gezero,[i,1])) 
						       then if op(gezero,[i,2]) < 0 
							    then return(Tableau::empty())
							    end_if
						       end_if
						  elif op(gezero,[i,2]) < 0 
						    then return(Tableau::empty())
						    else impliciteqs := impliciteqs minus {op(gezero,[i,1])}
						  end_if
					     end_if:
					     gezero := gezero minus {op(gezero,i)}:
					     next
					end_if:
					i := i+1
				  end_while:

				  muneqs := nops(unequations): 
				  mgez := nops(gezero):  
				  m := muneqs+mgez: 

				  for i from 1 to n do
				    internalorder[identlist[i]] := i
				  end_for:

				  for i from 1 to muneqs do
				    internalorder[hold(slk)[i]] := i-muneqs
				  end_for:
/*
				  for i from 1 to n do
				    internalorder[identlist[i]] := muneqs+i
				  end_for:
*/
				  for i from 1 to mgez do
				    internalorder[op(gezero,[i,1])] := n+muneqs+i
				  end_for:

				  tbl := array(1..m+2,1..n+2):

				  for j from 1 to n do
					tbl[1,j+2] := identlist[j]:					// first row : die Variablen 
					tbl[2,j+2] := 0							// second row : init with zero 
				  end_for:

				  for j from 1 to 2 do
				    for i from 1 to 2 do
					tbl[i,j]:=0;
				    end_for
				  end_for:

				  tbl[2,2] := -objfctscr:


				  if testtype(objfct,"_plus")						// 2.row : the objective function 
				  then for j from 1 to nops(objfct) do				
					 if testtype(op(objfct,j),"_mult") 
					 then tbl[2,internalorder[op(objfct,[j,1])]+2] := op(objfct,[j,2]):
					 elif testtype(op(objfct,j),DOM_IDENT)  or testtype(op(objfct,j),"_index")
					   then tbl[2,internalorder[op(objfct,j)]+2] := 1
					 end_if
				       end_for
				  elif testtype(objfct,"_mult") 
				    then tbl[2,internalorder[op(objfct,1)]+2] := op(objfct,2):
				    elif testtype(objfct,DOM_IDENT)  or testtype(objfct,"_index")
				      then tbl[2,internalorder[objfct]+2] := 1
				  end_if:

				  for i from 1 to muneqs do						// 1.column : the slackvariables 
				    tbl[i+2,1] := hold(slk)[i]:
				    assoziated[hold(slk)[i]] := op(constraints,op(unequations,[i,3])):	
				  end_for:

				  for i from 1 to mgez do
					tbl[muneqs+i+2,1] := op(gezero,[i,1])
				  end_for:

				  for i from 1 to muneqs do						// init A,b 

					tbl[i+2,2] := op(unequations,[i,2]):				// 2.column : b 

					for j from 1 to n do					 	// init A 
						tbl[i+2,j+2] := 0:
					end_for:

					if testtype(op(unequations,[i,1]),"_plus")
					then for j from 1 to nops(op(unequations,[i,1])) do		/* all operands of the 
													  left side of the eq */
					       if testtype(op(unequations,[i,1,j]),"_mult") 
					       then tbl[i+2,internalorder[op(unequations,[i,1,j,1])]+2] := op(unequations,[i,1,j,2])

					       else tbl[i+2,internalorder[op(unequations,[i,1,j])]+2] := 1
					       end_if
					     end_for
					elif testtype(op(unequations,[i,1]),"_mult") 
					  then tbl[i+2,internalorder[op(unequations,[i,1,1])]+2] := op(unequations,[i,1,2])
					  else tbl[i+2,internalorder[op(unequations,[i,1])]+2] := 1
					end_if
				  end_for:

				  i := 1:
				  while i <= mgez do					 		// init A,b 


					tbl[i+muneqs+2,2] := 0:						// 2.column : b 

					for j from 1 to n do					 	// init A 
						tbl[i+muneqs+2,j+2] := 0:
					end_for:

					if testtype(op(gezero,[i,2]),"_plus")
					then for j from 1 to nops(op(gezero,[i,2])) do			/* all operands of the 
													  left side of the eq */
					       if testtype(op(gezero,[i,2,j]),"_mult") 
					       then tbl[i+muneqs+2,internalorder[op(gezero,[i,2,j,1])]+2] := -op(gezero,[i,2,j,2])

					       elif testtype(op(gezero,[i,2,j]),DOM_IDENT) or testtype(op(gezero,[i,2,j]),"_index") 
						 then tbl[i+muneqs+2,internalorder[op(gezero,[i,2,j])]+2] := -1
						 else tbl[i+muneqs+2,2] := op(gezero,[i,2,j])
					       end_if
					     end_for
					elif testtype(op(gezero,[i,2]),"_mult") 
					  then tbl[i+muneqs+2,internalorder[op(gezero,[i,2,1])]+2] := -op(gezero,[i,2,2])
					  else tbl[i+muneqs+2,internalorder[op(gezero,[i,2])]+2] := -1
					end_if:
					i := i+1
				  end_while:

				  for i in allidents union {linopt::scr[i]$ i=1..scrollanz} do
					 if interval[i,"lower"] <> UNKNOWN and interval[i,"greater"] = 0 then
					   interval[i,"greater"] := FALSE
					 end_if
				  end_for:

				  for j from 1 to muneqs do
				    integer[hold(slk)[j]] := FALSE:
				    interval[hold(slk)[j],"greater"]:=0:
				    interval[hold(slk)[j],"lower"] := UNKNOWN
				  end_for:

				  i := 1:
				  while i <= nops(equations) do
				    if contains(impliciteqs,op(equations,[i,1])) then	
				      equations := equations minus {op(equations,i)}:
				      next
				    end_if:
				    i := i+1
				  end_while:	

				  new(Tableau,tbl,m,n,{linopt::scr[j]$ j=1..scrollanz,hold(slk)[j]$ j=1..muneqs},equations,
					freevars,muneqs,scrollanz,interval,assoziated,internalorder,integer)

				end_proc:




unalias(Tableau):
unalias(Heap):
