//    
// sello, 12.6.97, siehe Diplomarbeit Meinolf Sellmann 1997  

/*++
reoptbnd.mu -- reoptimize T, best solution known has associated costs B
++*/

alias(Heap=linopt::Heap):
alias(Tableau = linopt::Tableau):


Tableau::reopt_bound	:= 	proc(TT,B)

/* Eingabe: primal optimales Tableau T, nicht notwendig primal zulaessig, Wert der besten bekannten Loesung B
  Ausgabe: Ein optimales Tableau oder die leere Menge

  Im Unterschied zu ->reopt bricht diese Prozedur die Reoptimierung ab, sobald der Wert der dualen Loesung
  unter den vorgegebenen Wert B sinkt.
*/ 


				local T,
                  f,	// Status des Pivotelements	
				      piv;	// Pivotelement			

            begin

              T:=TT;
              
        userinfo(6," Entering Reoptimization "):

				  if T = {} then return(Tableau::empty()) end_if:

        userinfo(10,Tableau::uinfo(T)):
        userinfo(8," Result after this step   ", Tableau::result(T)):
        userinfo(8..9," Objective Function Value ", -T[1][2,2]):

 				  piv := Tableau::dualpivot(T[1],T[2],T[3],T[9]):

				  repeat 

        userinfo(10,Tableau::uinfo(T)):
        userinfo(8," Result after this step   ", Tableau::result(T)):
        userinfo(8..9," Objective Function Value ", -T[1][2,2]):

				    if piv[1] = 0 then f := 1: break end_if:
				    if piv[2] = 0 then f := 2: break end_if:

        userinfo(10,(" Pivot  i:j:tbl[i,j]      ",piv[1],piv[2],piv[3])):
        userinfo(10,(if piv[4] then userinfo(8," Upper Bound Pivoting ") else "" end_if)):

				    T := Tableau::optstep(T,piv):

				    if -T[1][2,2] >= B 
				      then 
        userinfo(8," Node pruned by better integer solution"):
					    return({}):	
				    end_if:

				    if T[1][2,piv[2]] = 0 
				      then 
        userinfo(10," Degeneration ascertained "):
					   piv := Tableau::dualpivot_deg(T[1],T[2],T[3],T[9],T[11])
				      else piv := Tableau::dualpivot(T[1],T[2],T[3],T[9])
				    end_if

				  until 1 = 0 end_repeat:

				  if f = 2 then

        userinfo(8," Node pruned by emptyness"):

				     return({})

				  end_if:

        userinfo(6," Reoptimization finished"):

				  return(T)

				end_proc:		


unalias(Tableau):
unalias(Heap):
