//    
// sello, 12.6.97, siehe Diplomarbeit Meinolf Sellmann 1997  

/*++
simplex.mu -- perform the simplex algorithm. Trys to obtain feasibility with the optimized phase I first.
++*/

alias(Heap=linopt::Heap):
alias(Tableau = linopt::Tableau):


Tableau::simplex	:= 	proc(TT)

/* Eingabe: Tableau T (muss nicht zulaessig sein!)
  Ausgabe: Status OPTIMAL, UNBOUNDED oder EMPTY, letztes Tableau und erreichter Zielfunktionswert, eventuell noch
           der dercreasing vector
*/

				local T,
                  f,		// Status des Pivotelementes	
				      piv,		// Pivotelement			
				      decrvektor;	// decreasing vector		

				begin

              T:=TT;
              
        userinfo(6," Entering Tableau::simplex "):

				  if T = {} then return([EMPTY,Tableau::empty(),infinity]) end_if:

				  piv := [0,0,0,0,T[2]+2]:

        userinfo(6," Entering Phase I "):

				  piv := Tableau::pivot1(T[1],T[2],T[3],T[9],piv[5]):

				  repeat 

        userinfo(10,Tableau::uinfo(T)):
        userinfo(8," Result after this step   ", Tableau::result(T)):
        userinfo(8..9," Objective Function Value ", -T[1][2,2]):

				    if piv[1] = 0 then f := 1: break end_if:
				    if piv[2] = 0 then f := 2: break end_if:

        userinfo(10,(" Pivot  i:j:tbl[i,j]      ",piv[1],piv[2],piv[3])):
        userinfo(10,(if piv[4] then userinfo(8," Upper Bound Pivoting ") else "" end_if)):
        userinfo(10,(" Last row unchecked       ",piv[5])):

				    T := Tableau::optstep(T,piv):

				    if T[1][piv[1],2] = 0
				      then 

        userinfo(10," Degeneration ascertained "): 

					   piv := Tableau::pivot1_deg(T[1],T[2],T[3],T[9],T[11],piv[5])
				      else piv := Tableau::pivot1(T[1],T[2],T[3],T[9],piv[5])
				    end_if:

				  until 1 = 0 end_repeat:

        userinfo(6," Phase I finished "):

				  if f = 2 then 
					return([EMPTY,Tableau::empty(),infinity])
				  end_if:

        userinfo(6," Entering Phase II "):

				  piv := Tableau::pivot2(T[1],T[2],T[3],T[9]):

				  repeat

				    if piv[2] = 0 then f := 1: break end_if:
				    if piv[1] = 0 then f := 2: break end_if:

        userinfo(10,(" Pivot  i:j:tbl[i,j]      ",piv[1],piv[2],piv[3])):
        userinfo(10,(if piv[4] then userinfo(8," Upper Bound Pivoting ") else "" end_if)):

				    T := Tableau::optstep(T,piv):

        userinfo(10,Tableau::uinfo(T)):
        userinfo(8," Result after this step   ", Tableau::result(T)):
        userinfo(8..9," Objective Function Value ", -T[1][2,2]):

				    if T[1][piv[1],2] = 0
				      then 

        userinfo(10," Degeneration ascertained "):

					   piv := Tableau::pivot2_deg(T[1],T[2],T[3],T[9],T[11])
				      else piv := Tableau::pivot2(T[1],T[2],T[3],T[9])
				    end_if

				  until 1 = 0 end_repeat:

        userinfo(6," Phase II finished"):

				  if f = 2 then

        userinfo(3..9,Tableau::uinfo(T)):
        userinfo(3..7," Result                   ", Tableau::result(T)):
        userinfo(3..7," Objective Function Value ", -T[1][2,2]):
        userinfo(3," Variable                 ",T[1][1,piv[2]]):

					decrvektor := Tableau::decvec(T,piv[2]):

					return([UNBOUNDED,T,-T[1][2,2],decrvektor])
				  end_if:

				  return([OPTIMAL,T,-T[1][2,2]])	

				end_proc:
unalias(Tableau):
unalias(Heap):
