//    
// sello, 12.6.97, siehe Diplomarbeit Meinolf Sellmann 1997  

/*++
step.mu -- perform one Simplexstep
++*/

alias(Heap=linopt::Heap):
alias(Tableau = linopt::Tableau):


Tableau::optstep		:=
proc(T,piv)


// Eingabe: Tableau T und Pivotelement (z.B. von ->pivot1)
// Ausgabe: Resultierendes Tableau nach diesem Schritt


  local i,j,			// Laufvariablen			
  h,			         // Hilfsvariable zum Tauschen von
							// Basis- und Nichtbasisvariable	
  tbl,m,n,interval;	// Tableaukomponenten		

begin
//        userinfo(8," Entering Tableau::optstep "):
  
  tbl := T[1]:
  m := T[2]:
  n := T[3]:
  interval := T[9]:
  
  if piv[1] = 1 then
    
    tbl := assignElements(tbl,([[i,piv[2]],-tbl[i,piv[2]]],
                  [[i,2],tbl[i,2]-interval[tbl[piv[1],
                  piv[2]],"lower"]*tbl[i,piv[2]]]) $ i=2..m+2):
    
    interval[tbl[piv[1],piv[2]],"greater"] :=
      not interval[tbl[piv[1],piv[2]],"greater"]:
    return(new(linopt::Transparent,tbl,m,n,T[4],T[5],T[6],T[7],T[8],
               interval,T[10],T[11],T[12]))
  end_if:
  
  if piv[4] and interval[tbl[piv[1],1],"lower"] <> UNKNOWN then 
    tbl := assignElements(tbl,[[piv[1],j],-tbl[piv[1],j]]$ j=3..n+2):
    piv[3] := -piv[3]:
    tbl[piv[1],2] := interval[tbl[piv[1],1],"lower"]-tbl[piv[1],2]:
    tbl[piv[1],piv[2]] := 1/piv[3]:
    
    tbl := assignElements(tbl,[[piv[1],j],tbl[piv[1],j]/piv[3]]$ j=2..piv[2]-1,
                          [[piv[1],j],tbl[piv[1],j]/piv[3]]$ j=piv[2]+1..n+2):
    interval[tbl[piv[1],1],"greater"] := not interval[tbl[piv[1],1],"greater"]	// TRUE means "higher value" 
  else tbl[piv[1],piv[2]] := 1/piv[3]:
    
    tbl := assignElements(tbl,[[piv[1],j],tbl[piv[1],j]/piv[3]]$ j=2..piv[2]-1,
                          [[piv[1],j],tbl[piv[1],j]/piv[3]]$ j=piv[2]+1..n+2):
  end_if:
  
  
  h := tbl[1,piv[2]]:
  tbl[1,piv[2]] := tbl[piv[1],1]:
  tbl[piv[1],1] := h:
  
  tbl := assignElements(tbl,([[i,j],tbl[i,j]-tbl[i,piv[2]]*tbl[piv[1],j]]
                             $ j=2..piv[2]-1,
                             [[i,j],tbl[i,j]-tbl[i,piv[2]]*tbl[piv[1],j]]
                             $ j=piv[2]+1..n+2)
                        $ i=2..piv[1]-1,
                        ([[i,j],tbl[i,j]-tbl[i,piv[2]]*tbl[piv[1],j]]
                         $ j=2..piv[2]-1,
                         [[i,j],tbl[i,j]-tbl[i,piv[2]]*tbl[piv[1],j]]
                         $ j=piv[2]+1..n+2)
                        $ i=piv[1]+1..m+2,
                        
                        [[i,piv[2]],-tbl[i,piv[2]]/piv[3]]$ i=2..piv[1]-1,
                        [[i,piv[2]],-tbl[i,piv[2]]/piv[3]]$ i=piv[1]+1..m+2):
  
  return(new(linopt::Transparent,tbl,m,n,T[4],T[5],T[6],T[7],T[8],interval,T[10],
             T[11],T[12]))
end_proc:




unalias(Tableau):
unalias(Heap):
