//    
// sello, 12.6.97 

/*++
convert.mu -- 
++*/

alias(Heap = linopt::Heap):
alias(Tableau = linopt::Tableau):
alias(Transparent = linopt::Transparent):

Transparent::convert	:=
proc(T)

// Eingabe: Tableau T
// Ausgabe: Zweidimensionales array, kanonisches Tableau mit Einheitsmatrix

  local i,j,k,l,				    // Laufvariablen				
  fulltbl,				          // Tableaukomponente tbl mit Identity	
  tbl,m,n,/*idenset,*/slackanz,
  interval,internalorder	    // Tableaukomponenten			
  /*pos,neg*/;				       // Bezeichner fuer Positiv- und Negativteil
									    // von Variablen			
begin
  if extop(T,0) <> Transparent then
    error(" Transparent tableau expected! ")
  end_if:
  tbl := T[1]:
  m := T[2]:
  n := T[3]:
  slackanz := T[7]:
  interval := T[9]:
  internalorder := T[11]:

  fulltbl := array(1..m+2,1..2+slackanz+n):
  
  fulltbl[2,2] := tbl[2,2]:
  fulltbl[1,1] := "linopt":
  fulltbl[2,1] := "obj":
  fulltbl[1,2] := "restr":

  for i from 3 to m+2 do
    fulltbl[i,1] := tbl[i,1]:
    fulltbl[i,2] := tbl[i,2]:
     
    j := internalorder[tbl[i,1]]+2+slackanz:
    fulltbl[1,j] := tbl[i,1]:
    fulltbl[2,j] := 0:
    for k from 3 to m+2 do
      if k = i
        then fulltbl[k,j] := 1
      else fulltbl[k,j] :=0
      end_if
    end_for
  end_for:
  
  for j from 3 to n+2 do
    l := internalorder[tbl[1,j]]+2+slackanz:
    for i from 1 to m+2 do
      fulltbl[i,l] := tbl[i,j]
    end_for
  end_for:
  
  return(fulltbl)
end_proc:

unalias(Transparent):
unalias(Tableau):
unalias(Heap):
