//    
// sello, 12.6.97 

/*++
newtrans.mu -- the ordinary datastructure of linear optimization problems
++*/

alias(Heap = linopt::Heap):
alias(Tableau = linopt::Tableau):
alias(Transparent = linopt::Transparent):

Transparent::new:=
proc(liste)				

//Eingabe: Lineares Optimierungsproblem, wie fuer -> Tableau
// Ausgabe: Erstes Tableau, ohne optimierte Behandlung von Gleichungen,
//          unbeschraenkten und beidseitig beschraenkten Variablen.


  local 	tbl,m,n,identset,
  insertedvars,equations,objfct,
  scrollanz,interval,		// Tableaukomponenten			
  objfctscr,			      // konstanter Teil der objfct		
  /*pos,neg,*/               // Bezeichner fuer Positiv- bzw. Negativ-
                           // Teil von Variablen         
  internalorder,           // order of variables                  
  identlist,               // list of variables                  
  /*freevars,*/              // set of vars not appearing in (un-)eqs 
  inteq,                   // internal (un)-equation              
  unequations,             // set of unequations                  
  constraints,             // set of constraints                  
  /*gezero,*/                // set of unequations >= 0             
  /*muneqs,mgez,*/           // number of unequations               
  h,                       // help variable                 
  i,j,                     // index for loops                     
  allidents,               // Menge saemtlicher Bezeichner     
  /*bounded,*/               // sets of bounded variables           
  assoziated;              // table: zu jeder slackvariablen die zu-
                           // gehoerige Restriktion         
  
begin
  
  userinfo(6," Entering Transparent Constructor "):
  
  
  if testargs()
    then
    if args(0) <> 1 then
      error("One list with list of (un)-equations and an objective function expected")
    end_if:
    
    
    if (nops(liste) < 2) or (nops(liste) > 3)               // input list ok? 
      then error("List with list of (un)-equations and an objective function expected")
    end_if:
    
    if not testtype(op(liste,1),DOM_LIST)
      then if not testtype(op(liste,1),DOM_SET)
             then error("List of (un)-equations expected")
           else liste[1] := [op(liste[1],i)$ i=1..nops(liste[1])]
           end_if
    end_if:
    
    objfct := op(liste,2):
    if (domtype(objfct) <> DOM_EXPR) and (domtype(objfct) <> DOM_IDENT) and not
      (testtype(objfct,DOM_INT) or testtype(objfct,DOM_FLOAT) or testtype(objfct,DOM_RAT))
      then error("No correct objective function specified")
    end_if:
    
    if nops(liste) >= 3 then
      if testtype(op(liste,3),DOM_SET)
        then for i from 1 to nops(op(liste,3)) do
               if not testtype(op(liste,[3,i]),DOM_IDENT) then
                 error("Set of restricted variables expected")
               end_if:
             end_for
      elif (op(liste,3) <> NonNegative)
        then
        error("Set of restricted variables expected")
      end_if:
    end_if:
    
    unequations := []:
    constraints := op(liste,1):
    equations := {}:
    insertedvars := {}:
    identset := {}:
    allidents := indets(constraints) union indets(objfct):
    
    if nops(liste) >= 3
      then if testtype(op(liste,3),DOM_SET)
             then for i in allidents minus op(liste,3) do
                    equations := equations union
                                 {i = hold(pos)[i] - hold(neg)[i]}:
                    insertedvars := insertedvars union
                                    {hold(pos)[i],hold(neg)[i]}:
                    interval[hold(pos)[i],"greater"] := 0:
                    interval[hold(pos)[i],"lower"] := UNKNOWN:
                    interval[hold(neg)[i],"greater"] := 0:
                    interval[hold(neg)[i],"lower"] := UNKNOWN
                  end_for:
             for i in op(liste,3) do
               interval[i,"greater"] := 0:
               interval[i,"lower"] := UNKNOWN
             end_for
           else for i in allidents do
                  interval[i,"greater"] := 0:
                  interval[i,"lower"] := UNKNOWN
                end_for
           end_if
    else for i in allidents do
           equations := equations union {i = hold(pos)[i] - hold(neg)[i]}:
           insertedvars := insertedvars union {hold(pos)[i],hold(neg)[i]}:
           interval[hold(pos)[i],"greater"] := 0:
           interval[hold(pos)[i],"lower"] := UNKNOWN:
           interval[hold(neg)[i],"greater"] := 0:
           interval[hold(neg)[i],"lower"] := UNKNOWN
         end_for
    end_if:
    
    scrollanz := 0:
    
    
//***********************************************************************************************************************************************************
    
    
    
    i := 1:
    
    while i <= nops(constraints) do             /* build internal set of
                            unequations */
      
      inteq := op(constraints,[i,1])-op(constraints,[i,2]):
      inteq := subs (inteq,equations):
      h := 0:
      if testtype(inteq,"_plus")
        then for j from 1 to nops(inteq) do        /* test all operands of
                            the unequation */
               if testtype(op(inteq,j),"_mult")
                 then if ( testtype(op(inteq,[j,2]),DOM_INT  ) or
                          testtype(op(inteq,[j,2]),DOM_FLOAT) or
                          testtype(op(inteq,[j,2]),DOM_RAT  ) ) and
                        ( testtype(op(inteq,[j,1]),DOM_IDENT) or
                         testtype(op(inteq,[j,1]),"_index") )
                        then identset := identset union {op(inteq,[j,1])}
                      else
                        error("Linear optimization only!")
                      end_if
               elif ( testtype(op(inteq,j),DOM_INT  ) or
                     testtype(op(inteq,j),DOM_FLOAT) or
                     testtype(op(inteq,j),DOM_RAT  ) )
                 then h := op(inteq,j)
               elif ( testtype(op(inteq,j),DOM_IDENT) or
                     testtype(op(inteq,j),"_index") )
                 then identset := identset union {op(inteq,j)}
               else
                 error("Linear optimization only!")
               end_if:
             end_for
      elif testtype(inteq,"_mult")
        then if ( testtype(op(inteq,2),DOM_INT  ) or
                 testtype(op(inteq,2),DOM_FLOAT) or
                 testtype(op(inteq,2),DOM_RAT  ) ) and
               ( testtype(op(inteq,1),DOM_IDENT) or
                testtype(op(inteq,1),"_index") )
               then identset := identset union {op(inteq,1)}
             else
               error("Linear optimization only!")
             end_if
      elif ( testtype(inteq,DOM_INT  ) or
            testtype(inteq,DOM_FLOAT) or
            testtype(inteq,DOM_RAT  ) )
        then h := inteq
      elif ( testtype(inteq,DOM_IDENT) or
            testtype(inteq,"_index") )
        then identset := identset union {inteq}
      else
        error("Linear optimization only!")
      end_if:
      
      if not ( testtype(inteq,DOM_IDENT) or testtype(inteq,"_index") or testtype(inteq,DOM_EXPR))
        then if bool(inteq > 0)              // -h ?????? 
               then return(Transparent::empty())
             end_if:
      else inteq := subs(inteq - h,0.0=0):
        unequations := append(unequations,[inteq,-h,i])
      end_if:
      
      if testtype(op(constraints,i),"_equal")
        then constraints[i] := op(constraints,[i,1]) >= op(constraints,[i,2]):
        next:
      elif not testtype(op(constraints,i),"_leequal")
        then error("Linear optimization only!")
      end_if:
      
      i := i+1
    end_while:                      // unequations 


//********************************************************************
//********************************************************************
    

    objfct := subs(objfct,equations):
    objfctscr := 0:
    
    if testtype(objfct,"_plus")
      then for j from 1 to nops(op(objfct)) do           /* test all operands of
                            the objective function */
             
             if testtype(op(objfct,j),"_mult")           // _mult(x,i) in Transparent order ! 
               then if ( testtype(op(objfct,[j,2]),DOM_INT  ) or
                        testtype(op(objfct,[j,2]),DOM_FLOAT) or
                        testtype(op(objfct,[j,2]),DOM_RAT  ) ) and
                      ( testtype(op(objfct,[j,1]),DOM_IDENT) or
                       testtype(op(objfct,[j,1]),"_index") )
                      then identset := identset union {op(objfct,[j,1])}
                    else
                      error("Linear optimization only!")
                    end_if
             elif testtype(op(objfct,j),DOM_IDENT) or testtype(op(objfct,j),"_index")
               then identset := identset union {op(objfct,j)}:
             elif not (testtype(op(objfct,j),DOM_INT  ) or
                       testtype(op(objfct,j),DOM_FLOAT) or
                       testtype(op(objfct,j),DOM_RAT  ))
               then
               error("Linear optimization only!")
             else objfctscr := op(objfct,j)
             end_if:
           end_for
    elif testtype(objfct,"_mult")               // _mult(x,i) in Transparent order ! 
      then if ( testtype(op(objfct,2),DOM_INT  ) or
               testtype(op(objfct,2),DOM_FLOAT) or
               testtype(op(objfct,2),DOM_RAT  ) ) and
             ( testtype(op(objfct,1),DOM_IDENT) or
              testtype(op(objfct,1),"_index") )
             then identset := identset union {op(objfct,1)}
           else
             error("Linear optimization only!")
           end_if
    elif ( testtype(objfct,DOM_IDENT) or testtype(objfct,"_index") )
      then identset := identset union {objfct}:
    elif not (testtype(objfct,DOM_INT  ) or
              testtype(objfct,DOM_FLOAT) or
              testtype(objfct,DOM_RAT  ))
      then
      error("Linear optimization only!")
    else objfctscr := objfct
                      
    end_if                       // test of the objective function 
    
    
//********************************************************************
//********************************************************************


  else                           // inner application 
    
    objfct := op(liste,2):
    unequations := []:
    equations := {}:
    insertedvars := {}:
    if testtype(op(liste,1),DOM_LIST)
      then constraints := op(liste,1)
    else constraints := [op(liste,[1,i])$ i=1..nops(liste[1])]
    end_if:
    identset :={}:
    allidents := indets(constraints) union indets(objfct):
    
    if nops(liste) >= 3
      then if testtype(op(liste,3),DOM_SET)
             then for i in allidents minus op(liste,3) do
                    equations := equations union
                                 {i = hold(pos)[i] - hold(neg)[i]}:
                    insertedvars := insertedvars union
                                    {hold(pos)[i],hold(neg)[i]}:
                    interval[hold(pos)[i],"greater"] := 0:
                    interval[hold(pos)[i],"lower"] := UNKNOWN:
                    interval[hold(neg)[i],"greater"] := 0:
                    interval[hold(neg)[i],"lower"] := UNKNOWN
                  end_for:
             for i in op(liste,3) do
               interval[i,"greater"] := 0:
               interval[i,"lower"] := UNKNOWN
             end_for
           else for i in allidents do
                  interval[i,"greater"] := 0:
                  interval[i,"lower"] := UNKNOWN
                end_for
           end_if
    else for i in allidents do
           equations := equations union {i = hold(pos)[i] - hold(neg)[i]}:
           insertedvars := insertedvars union {hold(pos)[i],hold(neg)[i]}:
           interval[hold(pos)[i],"greater"] := 0:
           interval[hold(pos)[i],"lower"] := UNKNOWN:
           interval[hold(neg)[i],"greater"] := 0:
           interval[hold(neg)[i],"lower"] := UNKNOWN
         end_for
    end_if:
    
    scrollanz := 0:
    
//********************************************************************
//********************************************************************
    
    i := 1:
    while i <= nops(constraints) do    // build internal set of unequations  

      inteq := op(constraints,[i,1])-op(constraints,[i,2]):
      inteq := subs (inteq,equations):
      h := 0:
      if testtype(inteq,"_plus")
        then for j from 1 to nops(inteq) do        /* test all operands of
                            the unequation */
               if testtype(op(inteq,j),"_mult")
                 then identset := identset union {op(inteq,[j,1])}
               elif ( testtype(op(inteq,j),DOM_INT  ) or
                     testtype(op(inteq,j),DOM_FLOAT) or
                     testtype(op(inteq,j),DOM_RAT  ) )
                 then h := op(inteq,j)
               else identset := identset union {op(inteq,j)}
               end_if:
             end_for
      elif testtype(inteq,"_mult")
        then identset := identset union {op(inteq,1)}
      elif ( testtype(inteq,DOM_INT  ) or
            testtype(inteq,DOM_FLOAT) or
            testtype(inteq,DOM_RAT  ) )
        then h := inteq
      else identset := identset union {inteq}
      end_if:
      
      if not ( testtype(inteq,DOM_IDENT) or testtype(inteq,"_index") or testtype(inteq,DOM_EXPR))
        then if bool(inteq > 0)              // -h ????????? 
               then return(Transparent::empty())
             end_if:
      else inteq := subs(inteq - h,0.0=0):
        unequations := append(unequations,[inteq,-h,i])
      end_if:
      
      if testtype(op(constraints,i),"_equal")
        then constraints[i] := op(constraints,[i,1]) >= op(constraints,[i,2]):
        next
      end_if:
      
      
      i := i+1
    end_while:                      // unequations 

//********************************************************************
//********************************************************************

    objfct := subs(objfct,equations):
    objfctscr := 0:
    
    if testtype(objfct,"_plus")
      then for j from 1 to nops(op(objfct)) do    // test all operands of
                                                  // the objective function 
             
             if testtype(op(objfct,j),"_mult")    // _mult(x,i) in Transparent
                                                  // order ! 
               then identset := identset union {op(objfct,[j,1])}
             elif testtype(op(objfct,j),DOM_IDENT) or testtype(op(objfct,j),"_index")
               then identset := identset union {op(objfct,j)}
             else objfctscr := op(objfct,j)
             end_if
           end_for
    elif testtype(objfct,"_mult")      // _mult(x,i) in Transparent order ! 
      then identset := identset union {op(objfct,1)}
    elif ( testtype(objfct,DOM_IDENT) or testtype(objfct,"_index") )
      then identset := identset union {objfct}
    else objfctscr := objfct
    end_if                       // test of the objective function 
    
  end_if:                        // testargs() 
  
//********************************************************************
//********************************************************************


  n := nops(identset):

  identlist := [op(identset,i)$ i=1..n]:
  
  m := nops(unequations):
  
  for i from 1 to n do
    internalorder[identlist[i]] := i
  end_for:
  
  for i from 1 to m do
    internalorder[hold(slk)[i]] := i-m
  end_for:

  tbl := array(1..m+2,1..n+2):

  for j from 1 to n do
    tbl[1,j+2] := identlist[j]:					// first row : die Variablen 
    tbl[2,j+2] := 0							// second row : init with zero 
  end_for:
  
  for j from 1 to 2 do
    for i from 1 to 2 do
      tbl[i,j]:=0;
    end_for
  end_for:
  
  tbl[2,2] := -objfctscr:
  
  
  if testtype(objfct,"_plus")						// 2.row : the objective function 
    then for j from 1 to nops(objfct) do
           if testtype(op(objfct,j),"_mult")
             then tbl[2,internalorder[op(objfct,[j,1])]+2] := op(objfct,[j,2]):
           elif testtype(op(objfct,j),DOM_IDENT)  or testtype(op(objfct,j),"_index")
             then tbl[2,internalorder[op(objfct,j)]+2] := 1
           end_if
         end_for
  elif testtype(objfct,"_mult")
    then tbl[2,internalorder[op(objfct,1)]+2] := op(objfct,2):
  elif testtype(objfct,DOM_IDENT)  or testtype(objfct,"_index")
    then tbl[2,internalorder[objfct]+2] := 1
  end_if:
  
  for i from 1 to m-1 do						// 1.column : the slackvariables 
    tbl[i+2,1] := hold(slk)[i]:
    if op(unequations,[i,3]) = op(unequations,[i+1,3])
      then assoziated[hold(slk)[i]] := op(constraints,[op(unequations,[i,3]),1])
      >= op(constraints,[op(unequations,[i,3]),2])
    else assoziated[hold(slk)[i]] := op(constraints,op(unequations,[i,3]))
    end_if
  end_for:
  tbl[m+2,1] := hold(slk)[m]:
  assoziated[hold(slk)[m]] := op(constraints,op(unequations,[m,3])):
  
  for i from 1 to m do							// init A,b 
    
    tbl[i+2,2] := op(unequations,[i,2]):				// 2.column : b 
    
    for j from 1 to n do					 	// init A 
      tbl[i+2,j+2] := 0:
    end_for:
    
    if testtype(op(unequations,[i,1]),"_plus")
      then for j from 1 to nops(op(unequations,[i,1])) do		/* all operands of the
                            left side of the eq */
             if testtype(op(unequations,[i,1,j]),"_mult")
               then tbl[i+2,internalorder[op(unequations,[i,1,j,1])]+2] := op(unequations,[i,1,j,2])
               
             else tbl[i+2,internalorder[op(unequations,[i,1,j])]+2] := 1
             end_if
           end_for
    elif testtype(op(unequations,[i,1]),"_mult")
      then tbl[i+2,internalorder[op(unequations,[i,1,1])]+2] := op(unequations,[i,1,2])
    else tbl[i+2,internalorder[op(unequations,[i,1])]+2] := 1
    end_if
  end_for:
  
  for j from 1 to m do
    interval[hold(slk)[j],"greater"]:=0:
    interval[hold(slk)[j],"lower"] := UNKNOWN
  end_for:
  
  new(Transparent,tbl,m,n,/*insertedvars union */{hold(slk)[i]$ i=1..m},
      equations,{},m,{},interval,assoziated,internalorder)
  
end_proc:

unalias(Transparent):
unalias(Tableau):
unalias(Heap):
