//    
// sello, 12.6.97 

/*++
phaseII.mu -- return the phase II tableau for the given optimal phase I tableau T
++*/

alias(Heap = linopt::Heap):
alias(Tableau = linopt::Tableau):
alias(Transparent = linopt::Transparent):


Transparent::phaseII_tableau :=	proc(T)

/* Eingabe: Tableau T
  Ausgabe: Phase II Tableau
*/				
				local piv, oldtbl,tbl,m,n,insertedvars,
				      /*equations,freevars,*/slackanz,
				      /*scrollanz,*/interval,//assoziated,
				      internalorder,			// Tableaukomponenten				
				      baslist,			        // Liste der Spalten zu PhaseI Schlupfvariablen	
				      i,j,				// Laufvariablen					
				      oldobj;				// alte Zielfunktion				

				begin

				  if T = {} then return(Transparent::empty()) end_if:

				  if T[8] = {} then return(T) end_if:

				  piv := Transparent::pivot1(T[1],T[2],T[3],T[9],T[2]+2):

				  if piv[1] = 0 
				    then piv := Transparent::pivot2(T[1],T[2],T[3],T[9]):
					 if piv[2] = 0 
				           then if T[1][2,2] <> 0 then return(Transparent::empty()) end_if:
						piv := Transparent::drive_out(T):
						if piv[1] <> 0 
						  then error(" Clean the basis from phase I slack variables first!"): 
						end_if
				           elif piv[1] = 0 
					       then error(" Phase I tableau is unbounded!")
					       else error(" Phase I tableau isn't optimal yet!")
				         end_if
				    elif piv[2] = 0 
					then return(Transparent::empty())
					else error(" Phase I tableau is infeasible!")
				  end_if:

				  slackanz := T[7]:
				  m := T[2]:
				  n := T[3]-slackanz:
				  oldobj := T[8]:

				  interval := T[9]:
				  internalorder := T[11]:

				  oldtbl := T[1]:
/*++
				  bas := {}:
				  for i from 3 to m+2 do
				    bas := bas union {internalorder[oldtbl[i,1]]}
				  end_for:
++*/

				  baslist := []:
				  for j from 3 to n+slackanz+2 do
				    if contains({hold(slk)[i]$ i=slackanz+1..2*slackanz},oldtbl[1,j])
				      then baslist := append(baslist,j)
				    end_if
				  end_for:

/*++
				  nbas := {j$ j=1..n**+slackanz**} minus bas:

				  H := Heap():

				  for i in bas do
				    H := Heap::ins(H,i,i)
				  end_for:
				  baslist := []:
				  while not Heap::empty(H) do
				    baslist := append(baslist,Heap::mini(H)+2):
				    H := Heap::del_min(H)
				  end_while:
++*/

			   	  tbl := Transparent::delcolumn(T[1],T[2],T[3],baslist):

				  tbl := assignElements(tbl,[[2,2],oldobj[0]],[[2,j],oldobj[tbl[1,j]]]$ j=3..n+2):

				  tbl := assignElements(tbl,[[2,j],tbl[2,j]-_plus((oldobj[tbl[i,1]]*tbl[i,j])$ i=3..m+2) ]$ j=2..n+2):

				  insertedvars := /*{hold(slk)[i]$ i=1..slackanz} union*/ T[4] minus {hold(slk)[i]$ i=slackanz+1..2*slackanz}:

				  for j from 3 to n+2 do
				    internalorder[tbl[1,j]] := internalorder[tbl[1,j]] - slackanz
				  end_for:

				  for i from 3 to m+2 do
				    internalorder[tbl[i,1]] := internalorder[tbl[i,1]] - slackanz
				  end_for:	

				  return(new(Transparent,tbl,m,n,insertedvars,T[5],T[6],slackanz,{},interval,T[10],internalorder))
				end_proc:

unalias(Transparent):
unalias(Tableau):
unalias(Heap):
