//    
// sello, 12.6.97 

/*++
simplex.mu -- perform the simplex-algorithm for the given tableau T
++*/

alias(Heap = linopt::Heap):
alias(Tableau = linopt::Tableau):
alias(Transparent = linopt::Transparent):

Transparent::simplex	:=
proc(TT)

// Eingabe: Tableau T
//  Ausgabe: optimales Tableau

  local
  T,
  f,				   // Status des Pivotelementes	
  piv,				// Pivotelement			
  /*erg,*/				// Ergebnis			
  internalorder,/*tbl,*/slackanz;	// Tableaukomponenten		
  
begin
  
  T:=TT; // to avoid warnings 
  
  userinfo(6," Entering (linopt::Transparent)::simplex "):
  
  if T = {} then return(Transparent::empty()) end_if:
  
  internalorder := T[11]:
  
  slackanz := T[7]:
  
  piv := [0,0,0,0,T[2]+2]:
  
  userinfo(6," Entering Phase I "):
  
  piv := Transparent::pivot1(T[1],T[2],T[3],T[9],piv[5]):
  
  repeat
    
    userinfo(10,Transparent::uinfo(T)):
    userinfo(8," Result after this step   ", Transparent::result(T)):
    userinfo(8..9," Objective Function Value ", -T[1][2,2]):
    
    if piv[1] = 0 then f := 1: break end_if:
    if piv[2] = 0 then f := 2: break end_if:
    
    userinfo(10,(" Pivot                    ",T[1][piv[1],1],T[1][1,piv[2]])):
    userinfo(10,(" Last row unchecked       ",piv[5])):
    
    T := Transparent::optstep(T,piv):
    
    if T[1][piv[1],2] = 0
      then
      
      userinfo(10," Degeneration ascertained "):
      
      piv := Transparent::pivot1_deg(T[1],T[2],T[3],T[9],T[11],piv[5])
    else piv := Transparent::pivot1(T[1],T[2],T[3],T[9],piv[5])
    end_if
    
  until 1 = 0 end_repeat:
  
  userinfo(6," Phase I finished "):
  
  if f = 2 then
    return(Transparent::empty())
  end_if:
  

  userinfo(6," Entering Phase II "):
  
  piv := Transparent::pivot2(T[1],T[2],T[3],T[9]):
  
  repeat

    if piv[2] = 0 then f := 1: break end_if:
    if piv[1] = 0 then f := 2: break end_if:
    
    userinfo(10,(" Pivot                    ",T[1][piv[1],1],T[1][1,piv[2]])):
    
    T := Transparent::optstep(T,piv):
    
    userinfo(10,Transparent::uinfo(T)):
    userinfo(8," Result after this step   ", Transparent::result(T)):
    userinfo(8..9," Objective Function Value ", -T[1][2,2]):
    
    if T[1][piv[1],2] = 0
      then
      
      userinfo(10," Degeneration ascertained "):
      
      piv := Transparent::pivot2_deg(T[1],T[2],T[3],T[9],T[11])
				      else piv := Transparent::pivot2(T[1],T[2],T[3],T[9])
    end_if

  until 1 = 0 end_repeat:
  
  userinfo(6," Phase II finished "):

  if f = 2 then

    userinfo(3..9,Transparent::uinfo(T)):
    userinfo(3..7," Result                   ", Transparent::result(T)):
    userinfo(3..7," Objective Function Value ", -T[1][2,2]):
    userinfo(3," Variable                 ",T[1][1,piv[2]]):
    
    return(UNBOUNDED)
  end_if:
  
  return(T)
  
end_proc:

unalias(Transparent):
unalias(Tableau):
unalias(Heap):
