//    
// sello, 12.6.97, siehe Diplomarbeit Meinolf Sellmann 1997 


/*++
arrange.mu -- arrange the corners of a twodimensional feasible region, so that they build a circle
++*/

alias(Heap = linopt::Heap):
alias(Tableau = linopt::Tableau):


linopt::arrange_corners	:=	proc(cornerset)

				local center,		// the center of the given corners 	
				      i,		// Laufvariable				
				      leftH,rightH,	/* Heap fuer die Ecken links und rechts
							  vom Zentrum				*/
				      arrangedList;	// resultierende Liste der Ecken		

				begin
				  if nops(cornerset) < 4 then return([op(cornerset,i)$ i=1..nops(cornerset)]) end_if:

				  center := [_plus(op(cornerset,[i,1])$ i=1..nops(cornerset))/nops(cornerset),
					     _plus(op(cornerset,[i,2])$ i=1..nops(cornerset))/nops(cornerset)]:

				  leftH := Heap():
				  rightH := Heap():
				  arrangedList := []:

				  for i from 1 to nops(cornerset) do

				    if op(cornerset,[i,1]) <= center[1]
				      then leftH := Heap::ins(leftH,
							      float((op(cornerset,[i,2])-center[2])/sqrt((op(cornerset,[i,2])-center[2])^2+
												(op(cornerset,[i,1])-center[1])^2)),
							      op(cornerset,i))
				      else rightH := Heap::ins(rightH,
							       float((center[2]-op(cornerset,[i,2]))/sqrt((op(cornerset,[i,2])-center[2])^2+
												 (op(cornerset,[i,1])-center[1])^2)),
							       op(cornerset,i))
				    end_if
				  end_for:

				  while not Heap::empty(leftH) do
				    arrangedList := append(arrangedList,Heap::mini(leftH)):
				    leftH := Heap::del_min(leftH)
				  end_while:

				  while not Heap::empty(rightH) do
				    arrangedList := append(arrangedList,Heap::mini(rightH)):
				    rightH := Heap::del_min(rightH)
				  end_while:

				  return(arrangedList)
				end_proc:



				
unalias(Tableau):
unalias(Heap):
