//    
// sello, 12.6.97, siehe Diplomarbeit Meinolf Sellmann 1997 


/*++
branch.mu -- return the kids of tableau T in the Algorithm of Dakin
++*/

alias(Heap = linopt::Heap):
alias(Tableau = linopt::Tableau):


linopt::branch	:=
proc(T)


/* Liefert fuer ein gegebenes (optimales) Tableau eine Liste der beiden Tableaus (evtl, leere Menge!) zu den Sohnproblemen
  im Algorithmus nach Dakin. Die Auswahl der eingefuehrten Branchingschnitte erfolgt zunaechst nach den zielfunktions-
  orientierten Strafkosten und bei Auftretenden Mehrdeutigkeiten nach euklidischen Gesichtspunkten. */

  local
  firstpivot,			/* Pivotinformation zum Sohnproblem mit den
									  kleineren assoziierten Strafkosten		*/
  firstpivotdown, firstpivotup,	// Pivotinformation zu ->TU und TO
  i,				// Laufvariable, Index der Tableauzeilen
  tbl,m,interval,integer,		// Tableaukomponenten
  TU,TO,				/* Tableaus zum unteren und oberen
									  generierten Sohnproblem 			*/
  H,/*L,*/				/* Heaps zur Bestimmung der Branchingvariablen
									  nach maximalen objective penalties oder
									  eukidean penalties				*/
  pen,				// minimum der objective penalties
  penlist,				// Rueckgabe von obj_pen
  maxi,				/* Liste zur Variablen mit maximalen objective
									  penalties, [ass. Zeile, minimale objective
									  Sohnpenalties, zugh. ->penlist]		*/ 
  bestval,				/* maximales Minimum der objective
									  Sohnproblempenalties				*/
  assmaxi,				/* zu jeder Zeile assoziiertes ->maxi, eventuell
									  gibts ja mehrere				*/
  tieindex,ties,			/* Liste und Anzahl der Branchingvariablen mit
									  denselben maximalen assoziierten objective 
									  penalties					*/
  pivotcolumn,bound,upperboundpivot,/* zum Sohnproblem mit den kleineren assoziierten
									  objective penalties die erste(n) Pivotspalte(n), der
									  Rundungswert zur neuen unteren oder oberen
									  Schranke der Branchingvariablen und ob es sich
									  beim ersten Pivotschritt um einen Sonderschritt
									  mit einer beidseitig beschraenkten Variablen
									  handelt					*/
  s;

begin
  tbl := T[1]:
  
  m := T[2]:
  integer := T[12]:
  interval := T[9]:
  
  H := Heap():
  
  for i from 3 to m+2 do
    if integer[tbl[i,1]] and tbl[i,2]<>floor(tbl[i,2]) then
      penlist := linopt::obj_penalty(T,i):
      pen := min(penlist[s]$ s=1..2):
      H := Heap::ins(H,-pen,[i,pen,penlist]):
    end_if
  end_for:


  maxi := Heap::mini(H):
  bestval := maxi[2]:
  
  ties := 0:

  tieindex := []:
  while not Heap::empty(H) and maxi[2] = bestval do
    i := maxi[1]:
    tieindex := append(tieindex,i):
    if maxi[3][1] < maxi[3][2] then
      pivotcolumn[i] := maxi[3][3]:
      assert(testtype(pivotcolumn[i], Type::ListOf(DOM_INT)));
      bound[i] := ceil(tbl[i,2]):
      assmaxi[i] := maxi:
      upperboundpivot[i] := maxi[3][5]
    else
      pivotcolumn[i] := maxi[3][4]:
      assert(testtype(pivotcolumn[i], Type::ListOf(DOM_INT)));
      bound[i] := floor(tbl[i,2]):
      assmaxi[i] := maxi:
      upperboundpivot[i] := maxi[3][6]
    end_if:

    H := Heap::del_min(H):
    maxi := Heap::mini(H):
    ties := ties+1
  end_while:

  if ties > 1 or nops(pivotcolumn[i]) > 1 then
    firstpivot := linopt::eukl_penalty(T, tieindex, pivotcolumn,
                                       bound, upperboundpivot)
  else
    firstpivot := [i,pivotcolumn[i][1], upperboundpivot[i][1]]
  end_if:

  i := firstpivot[1]:
  maxi := assmaxi[i]:

  if maxi[3][1] < maxi[3][2] then
    firstpivotdown := [firstpivot[1],firstpivot[2],firstpivot[3]]:
    firstpivotup := [firstpivot[1],op(maxi[3][4],1),op(maxi[3][6],1)]
  else
    firstpivotdown := [firstpivot[1],op(maxi[3][3],1),op(maxi[3][5],1)]:
    firstpivotup := [firstpivot[1],firstpivot[2],firstpivot[3]]
  end_if:

  if interval[tbl[i,1],"lower"] = UNKNOWN then
    if maxi[3][2] = infinity then
      TO := {}
    else
      TO := Tableau::newlowerbound(T,i,floor(tbl[i,2])+1):
//print(Tableau::dualpivot(TO[1],TO[2],TO[3],TO[9])):
      
      TO := Tableau::optstep(TO,[i,firstpivotup[2],TO[1][firstpivotup[1],firstpivotup[2]],firstpivotup[3]])
    end_if:
    if maxi[3][1] = infinity
      then TU := {}
    elif interval[tbl[i,1],"greater"] = UNKNOWN
      then TU := Tableau::newupperbound(T,i,floor(tbl[i,2])):
      TU := Tableau::optstep(TU,[i,firstpivotdown[2],TU[1][i,firstpivotdown[2]],firstpivotdown[3]])
    elif floor(tbl[i,2]) = 0
      then TU := Tableau::newequation(T,i,0,[i,firstpivotdown[2]])
    else TU := Tableau::newupperbound(T,i,floor(tbl[i,2])):
      TU := Tableau::optstep(TU,[i,firstpivotdown[2],TU[1][i,firstpivotdown[2]],firstpivotdown[3]])
    end_if
  else
    if maxi[3][2] = infinity then
      TO := {}
    elif interval[tbl[i,1],"lower"] > floor(tbl[i,2])+1 then
      if interval[tbl[i,1],"greater"] then
        TO := Tableau::newlowerbound(T,i,floor(interval[tbl[i,1],"lower"]-tbl[i,2])+1):
        TO := Tableau::optstep(TO,[i,firstpivotup[2],TO[1][i,firstpivotup[2]],firstpivotup[3]])
      else
        TO := Tableau::newlowerbound(T,i,floor(tbl[i,2])+1):
        TO := Tableau::optstep(TO,[i,firstpivotup[2],TO[1][i,firstpivotup[2]],firstpivotup[3]])
      end_if
    elif interval[tbl[i,1],"lower"] = floor(tbl[i,2])+1 then
      TO := Tableau::newequation(T,i,floor(tbl[i,2])+1,[i,firstpivotup[2]])
    else
      TO := {}
    end_if:
					 
    if maxi[3][1] = infinity then
      TU := {}
    elif interval[tbl[i,1],"greater"] then
      if floor(interval[tbl[i,1],"lower"]-tbl[i,2]) = 0 then
        TU := Tableau::newequation(T,i,0,[i,firstpivotdown[2]])
      else
        TU := Tableau::newupperbound(T,i,floor(interval[tbl[i,1],"lower"]
                                               -tbl[i,2])):
        TU := Tableau::optstep(TU,[i,firstpivotdown[2],TU[1][i,firstpivotdown[2]],firstpivotdown[3]])
      end_if
    elif floor(tbl[i,2]) = 0 then
      TU := Tableau::newequation(T,i,0,[i,firstpivotdown[2]])
    else
      TU := Tableau::newupperbound(T,i,floor(tbl[i,2])):
      TU := Tableau::optstep(TU,[i,firstpivotdown[2],TU[1][i,firstpivotdown[2]],firstpivotdown[3]])
    end_if
  end_if:

  return([TO,TU])

end_proc:


				
unalias(Tableau):
unalias(Heap):
