//    
// sello, 12.6.97, siehe Diplomarbeit Meinolf Sellmann 1997 


/*++
corners.mu -- calculate all (feasible) corners of a linear problem
++*/

alias(Heap = linopt::Heap):
alias(Tableau = linopt::Tableau):

linopt::corners	:=
proc(A,var)

// Eingabe: Lineares Optimierungproblem A, Reihenfolde der Variablen von A,
//           Optionen Logic und All 
//  Ausgabe: Menge der (zulaessigen) Ecken, die davon zielfunktionsgroesste
//           und der dazugehoerige Zielfunktionswert 
  
  local i,j,l,					// Laufvariablen					
  T,					         // Tableau					
  tbl,m,n,interval,			// Tableaukomponenten				
  erg,					      // Menge der Ecken zum aktuellen Tableau,
									//	 kann wegen ->freier variablen mehr
                           //  als eine sein!
  finished,					   // aktuell simulierte repeat-Schleife zu Ende?	
  logic,all,				   // Optionen					
  z,					         // Z aus der Diplomarbeit			
  upperboundcolumns,			// Spaltenindizes zu noch nicht an der oberen
                           // Grenze fixierten beidseitig beschraenkten
                           // Variablen					
  indices,					   // Zeilenindizes zu Variablen assoziiert zu
                           // tauschbaren Ebenen. Falls Logic gesetzt ist,
                           // sind das alle, sonst nur die zu nicht freien
                           // Variablen					
  cornerset,bestcornerval,bestcorner;	// Ergebniskomponenten				
  
begin
  userinfo(8, "Entering linopt::corners"):
  all := FALSE:
  logic := FALSE:
  bestcornerval := FALSE ; // Dummy Initialisierung.
                           //  Bedeutung: Noch kein Wert vorhanden
  bestcorner := FALSE;
                           
  if testargs()
    then if args(0) > 4 then
           error("Too many arguments. Problem and list of two variables expected.")
         end_if:
    
    if args(0) > 3
      then if {All,Logic} = {args(3),args(4)}
             then logic := TRUE:
             all := TRUE
           else error("Expected options are All and/or Logic")
           end_if
    elif args(0) > 2
      then if args(3) = All
             then all := TRUE
           elif args(3) = Logic
             then logic := TRUE
           else error("Expected options are All and/or Logic")
           end_if
    end_if:
    
    if not testtype(var,DOM_LIST) then
      error("Problem in variables and list of these variables expected")
    end_if:
    
  else if args(0) > 3
         then logic := TRUE:
         all := TRUE
       elif args(0) > 2
         then if args(3) = All
                then all := TRUE
              else logic := TRUE
              end_if
       end_if
  end_if:							// testargs 
  
  if {var[i]$ i=1..nops(var)} <> indets(A[1]) union indets(A[2]) then
    error("Problem in variables and list of these variables expected")
  end_if:
  
  cornerset := {}:
  
  T := Tableau(A):
  
  if T = {} then return({}) end_if:

  m := T[2]:
  n := T[3]:
  
  if n = 0 then
    erg := Tableau::result(T,Any):
    cornerset := cornerset union
                 {[subs(var[i],erg[j])$ i=1..nops(var)]$ j=1..nops(erg)}:
    return([cornerset,-T[1][2,2]])
  end_if:
  
  interval := T[9]:
  
  indices := {i$ i=3..m+2}:
  
  if not logic then
    tbl := T[1]:
    for i from 3 to m+2 do
      if interval[tbl[i,1],"greater"] = UNKNOWN then
        indices := indices minus {i}
      end_if
    end_for:
    for j from 3 to n+2 do
      if interval[tbl[1,j],"greater"] = UNKNOWN then
        finished := TRUE:
        for i in indices do
          if T[1][i,j] <> 0 then
            finished := FALSE:
            T := Tableau::optstep(T,[i,j,T[1][i,j],FALSE]):
            break
          end_if
        end_for:
        if finished then return({}) end_if:
        indices := indices minus {i}
      end_if:
    end_for
  end_if:
  
  j := n+2:
  
  z[3] := [op(indices,i)$ i=1..nops(indices)]:
  
  for l from 4 to n+2 do
    z[l] := z[3]
  end_for:
  
  upperboundcolumns := {}:

  for l from 3 to n+2 do
    if interval[T[1][1,l],"lower"] <> UNKNOWN then
      upperboundcolumns := upperboundcolumns union {l}
    end_if
  end_for:
  
  repeat
    
    if j = n+2 and (all or Tableau::feasible(T)) then
      erg := Tableau::result(T,Any):
      cornerset := cornerset union
                   {[subs(var[i],erg[j])$ i=1..nops(var)]$ j=1..nops(erg)}:
      if bestcornerval=FALSE or -T[1][2,2]>bestcornerval then
        bestcornerval := -T[1][2,2]:
        bestcorner := [subs(var[i],erg[1])$ i=1..nops(var)]
      end_if
    end_if:
    
    if contains(upperboundcolumns,j)
      then upperboundcolumns := upperboundcolumns minus {j}:
      T := Tableau::optstep(T,[1,j,T[1][1,j],TRUE]):
    else if z[j] = [] then j := j-1: next end_if:
      finished := TRUE:
      for l from 1 to nops(z[j]) do
        if T[1][z[j][l],j] <> 0 then
          finished := FALSE:
          i := z[j][l]:
          delete z[j][l] ;
          break
        end_if
      end_for:
      if finished then j := j-1: next end_if:
      T := Tableau::optstep(T,[i,j,T[1][i,j],FALSE]):
      if interval[T[1][1,j],"lower"] <> UNKNOWN then
        upperboundcolumns := upperboundcolumns union {j}
      end_if
    end_if:
    
    if j < n+2 then
      for l from j+1 to n+2 do
        z[l] := z[j]:
        if interval[T[1][1,l],"lower"] <> UNKNOWN then
          upperboundcolumns := upperboundcolumns union {l}
        end_if
      end_for:
      j := n+2:
    end_if:
    
  until j<3 end_repeat:
  
  return([cornerset,bestcornerval,bestcorner])
end_proc:



				
unalias(Tableau):
unalias(Heap):
