//    
// sello, 12.6.97, siehe Diplomarbeit Meinolf Sellmann 1997 


/*++
intopt.mu -- minimize a Tableau with respect to integer constraints, uses ->simplex.
++*/

alias(Heap = linopt::Heap):
alias(Tableau = linopt::Tableau):

	
linopt::intopt:=
proc(TT)

// Eingabe: ein relaxiert optimales Tableau
// Ausgabe: Liste mit Status OPTIMAL, EMPTY oder UNBOUNDED, entsprechend
// eine Menge von Gleichungen, die leer sein kann oder noch von
// einem Parameter abhaengt

  local T,
  H,		   // Heap der aktiven Knoten		
  erg,		// aktuelle Loesung der Relaxation  
  best,		// beste bis dato gefundene Loesung 	
  brnch,		// Rueckgabe von -> branch		
  TL,TR,		// neu generierte Soehne des aktuell in
            // Arbeit befindlichen Knotens		
  emptyHeap,	// boolscher Wert: Heap leer?		
  unbounded,	// bool: War die Loesung der ersten Relaxation unbeschraenkt? 
  decrvektor,	// falls ->unbounded der decreasing vector				
  tbl;		   // erste Tableaukomponente		
  
begin
  
  userinfo(4," Entering LINOPT::intopt "):
  best:= NIL;
  unbounded := FALSE:
  
  T := Tableau::simplex(TT):
  
  if T[1]=EMPTY then return([EMPTY,T[2],infinity]) end_if:
  
  if T[1] = UNBOUNDED
    then tbl := T[2]:
    decrvektor := T[4]:
    unbounded := TRUE:
    erg := Tableau::elimobj(T[2]):
  else erg := T[2]
  end_if:
  
  if Tableau::intfeasible(erg)
    then if unbounded
           then return([UNBOUNDED,erg,0,decrvektor])
         else return([OPTIMAL,erg,-erg[1][2,2]])
         end_if
  end_if:
  
//if args(0) > 1 then Tableau::probe(args(2),Tableau::result(erg)) end_if:
  
  H := Heap():
  H := Heap::ins(H,-erg[1][2,2],erg):
  emptyHeap := FALSE:
  
  
  
  while (not emptyHeap) and best = NIL do
    brnch := linopt::branch(erg):
    TL := brnch[1]:
    TR := brnch[2]:

    erg := Tableau::reopt(TL):
    
//if args(0) > 1 and bool(extop(erg,0)=Tableau) then Tableau::probe(args(2),Tableau::result(erg)) end_if:
    
    
    if bool(extop(erg,0)=linopt::Transparent) or
       bool(extop(erg,0)=Tableau)           // else empty ! 
      then if Tableau::intfeasible(erg)
             then best := erg:
             erg := Tableau::reopt(TR):
             
//if args(0) > 1 and bool(extop(erg,0)=Tableau) then Tableau::probe(args(2),Tableau::result(erg)) end_if:
             
             if bool(extop(erg,0)=linopt::Transparent) or
               bool(extop(erg,0)=Tableau)        			  // else empty ! 
               then if Tableau::intfeasible(erg)
                      then if -best[1][2,2] > -erg[1][2,2]
                             then best := erg
                           end_if:
                      H := Heap::del_min(H)
                    elif -best[1][2,2] > -erg[1][2,2]
                      then H := Heap::del_ins(H,-erg[1][2,2],erg)
                    else H := Heap::del_min(H)
                    end_if
             else H := Heap::del_min(H)
             end_if
           else H := Heap::del_ins(H,-erg[1][2,2],erg):
             erg := Tableau::reopt(TR):
             
//if args(0) > 1 and bool(extop(erg,0)=Tableau) then Tableau::probe(args(2),Tableau::result(erg)) end_if:
             
             if bool(extop(erg,0)=linopt::Transparent) or
               bool(extop(erg,0)=Tableau)         				// else empty ! 
               then if Tableau::intfeasible(erg)
                      then best := erg
                    else H := Heap::ins(H,-erg[1][2,2],erg)
                    end_if
             end_if
           end_if
    else erg := Tableau::reopt(TR):
      
//if args(0) > 1 and bool(extop(erg,0)=Tableau) then Tableau::probe(args(2),Tableau::result(erg)) end_if:
      
      if bool(extop(erg,0)=linopt::Transparent)	or
        bool(extop(erg,0)=Tableau)   					// else empty ! 
        then if Tableau::intfeasible(erg)
               then best := erg:
               H := Heap::del_min(H)
             else H := Heap::del_ins(H,-erg[1][2,2],erg)
             end_if
      else H := Heap::del_min(H)
      end_if
    end_if:
    if not Heap::empty(H)
      then erg := Heap::mini(H)
    else emptyHeap:=TRUE
    end_if
  end_while:
  
  
  while (not emptyHeap) and  -best[1][2,2] > -erg[1][2,2] do			/* one all-integer-
                                                       solution is known */
    brnch := linopt::branch(erg):
    TL := brnch[1]:
    TR := brnch[2]:
    
    erg := Tableau::reopt_bound(TL,-best[1][2,2]):
    
//if args(0) > 1 and bool(extop(erg,0)=Tableau) then Tableau::probe(args(2),Tableau::result(erg)) end_if:
    
    
    if bool(extop(erg,0)=linopt::Transparent) or
      bool(extop(erg,0)=Tableau)   						// else empty ! 
      then if Tableau::intfeasible(erg)
             then if -best[1][2,2] > -erg[1][2,2]
                    then best := erg
                  end_if:
             erg := Tableau::reopt_bound(TR,-best[1][2,2]):
             
//if args(0) > 1 and bool(extop(erg,0)=Tableau) then Tableau::probe(args(2),Tableau::result(erg)) end_if:
             
             if bool(extop(erg,0)=linopt::Transparent) or
               bool(extop(erg,0)=Tableau) 				// else empty ! 
               then if Tableau::intfeasible(erg)
                      then if -best[1][2,2] > -erg[1][2,2]
                             then best := erg
                           end_if:
                      H := Heap::del_min(H)
                    elif -best[1][2,2] > -erg[1][2,2]
                      then H := Heap::del_ins(H,-erg[1][2,2],erg)
                    else H := Heap::del_min(H)
                    end_if
             else H := Heap::del_min(H)
             end_if
           elif -best[1][2,2] > -erg[1][2,2]
             then H := Heap::del_ins(H,-erg[1][2,2],erg):
             erg := Tableau::reopt(TR):
             
//if args(0) > 1 and bool(extop(erg,0)=Tableau) then Tableau::probe(args(2),Tableau::result(erg)) end_if:
             
             if bool(extop(erg,0)=linopt::Transparent) 	or
               bool(extop(erg,0)=Tableau) 				// else empty ! 
               then if Tableau::intfeasible(erg)
                      then if -best[1][2,2] > -erg[1][2,2]
                             then best := erg
                           end_if
                    elif -best[1][2,2] > -erg[1][2,2]
                      then H := Heap::ins_bound(H,-erg[1][2,2],erg,-best[1][2,2])
                    end_if
             end_if
           else erg := Tableau::reopt_bound(TR,-best[1][2,2]):
             
//if args(0) > 1 and bool(extop(erg,0)=Tableau) then Tableau::probe(args(2),Tableau::result(erg)) end_if:
             
             if bool(extop(erg,0)=linopt::Transparent) or
               bool(extop(erg,0)=Tableau) 				// else empty ! 
               then if Tableau::intfeasible(erg)
                      then if -best[1][2,2] > -erg[1][2,2]
                             then best := erg
                           end_if:
                      H := Heap::del_min(H)
                    elif -best[1][2,2] > -erg[1][2,2]
                      then H := Heap::del_ins(H,-erg[1][2,2],erg)
                    else H := Heap::del_min(H)
                    end_if
             else H := Heap::del_min(H)
             end_if
           end_if
    else erg := Tableau::reopt_bound(TR,-best[1][2,2]):
      
//if args(0) > 1 and bool(extop(erg,0)=Tableau) then Tableau::probe(args(2),Tableau::result(erg)) end_if:
      
      if bool(extop(erg,0)=linopt::Transparent)	or
        bool(extop(erg,0)=Tableau) 					// else empty ! 
        then if Tableau::intfeasible(erg)
               then if -best[1][2,2] > -erg[1][2,2]
                      then best := erg
                    end_if:
               H := Heap::del_min(H)
             elif -best[1][2,2] > -erg[1][2,2]
               then H := Heap::del_ins(H,-erg[1][2,2],erg)
             else H := Heap::del_min(H)
             end_if
      else H := Heap::del_min(H)
      end_if
    end_if:
    if not Heap::empty(H)
      then erg := Heap::mini(H)
    else emptyHeap:=TRUE
    end_if
  end_while:
  
  if best = NIL
    then return([EMPTY,{},infinity])
  elif unbounded
    then return([UNBOUNDED,best,0,decrvektor])
  else return([OPTIMAL,best,-best[1][2,2]])
  end_if
  
end_proc:

				
unalias(Tableau):
unalias(Heap):
