//    
// sello, 12.6.97, siehe Diplomarbeit Meinolf Sellmann 1997 

/*++
minimize.mu -- minimize an MIP
++*/

alias(Heap = linopt::Heap):
alias(Tableau = linopt::Tableau):





    linopt::minimize	:= 	proc(liste)

// liefert fuer ein LP, IP oder MIP eine minimale Loesung 			
// Eingabe: Eine Liste mit einer Liste von Restriktionen, der Zielfunktion und	
//          optional einer Menge von Variablen >= 0 respektive 'NonNegative',	
//	   falls alle Variablen nichtnegativ sein sollen, sowie einer optionalen
//	   Menge von Variablen, die nur ganzzahlige Werte annehmen duerfen	
//	   respektive 'All', falls dies fuer alle Variablen gilt.		
//	   Der Liste darf fuer ein LP die Option 'DualPrices' folgen		

// Ausgabe: Eine Liste mit drei Elementen. 					
//	   1.) Status: 'OPTIMAL', 'UNBOUNDED', oder 'EMPTY'			
//	   2.) Variablenbelegung: Fuer 'OPTIMAL' Menge mit Gleichungen der 	
//					Form x=3,				
//				  fuer 'EMPTY' die leere Menge und		
//				  fuer 'UNBOUNDED' eine Variablenbelegung 	
//					in Abhaengigkeit von einer neuen 	
//					Variable PHI.				
//	   3.) Zielfunktionswert: Fuer 'OPTIMAL' eine rationale Zahl,		
//				  fuer 'EMPTY' -infinity und			
//				  fuer 'UNBOUNDED' eine lineare Funktion in PHI	
// 	   Sofern die Option 'DualPrices' gesetzt wurde, wird noch eine Menge	
//	   mit den Schattenpreisen fuer jede Restriktion angegeben		


				local T,			// aktuelles Tableau 		
				      erg,			// Ergebnis 			
				      testargues,		// Wert von testargs()		
				      dual,			// Option DualPrices gesetzt 	
				      decrvektor,		// fuer unbeschraenkte Zielfunk-	
								// tion der decreasing-vektor	
				      				// gibt fuer unbeschraenkte Ziel-
								// funktion den konstanten Anteil
								// an				
					i;
				begin

        userinfo(1," Entering LINOPT::minimize "):

				  if testargs() 
				  then if args(0) < 1 or args(0) > 2 or args(0) = 2 and args(2) <> DualPrices then 
					 error("One list and optional 'DualPrices' expected!")
				       end_if:

				       if not testtype(liste,DOM_LIST) 
					 then error(" List with set of (un-)equations and an objective function expected!")
				       end_if:

				       if (nops(liste) < 2) or (nops(liste) > 4)				// input list ok? 
					 then error("List with set of (un)-equations and an objective function expected!")
				       end_if 
				  end_if:

				  if args(0) > 1 
				    then if nops(liste) = 4 then error("Option 'DualPrices' is only reasonable for an LP!") end_if:
				         dual := TRUE
				    else dual := FALSE 
				  end_if:

				  testargues := testargs(TRUE):

				  T := Tableau(liste):

				  testargs(testargues):
				  
				  if T = {} then return([EMPTY,{},infinity]) end_if:
 
				  if nops(liste) = 4
				    then T := linopt::intopt(T,liste)
				    else T := Tableau::simplex(T,liste)
				  end_if:

				  if T[1] = EMPTY then return([EMPTY,T[2],T[3]]) end_if:

				  erg := Tableau::result(T[2]):
				  Tableau::probe(liste,erg,TRUE):				//TEST

				  if T[1] = UNBOUNDED then 
				    decrvektor := T[4]:
				    return([UNBOUNDED,{(op(erg,[i,1])=op(erg,[i,2])+decrvektor[op(erg,[i,1])])$ i=1..nops(erg)},
						subs(liste[2],erg)+decrvektor[linopt::objconst]]):
				  end_if:

				  if dual then return([OPTIMAL,erg,T[3]],Tableau::dual_prices(T[2])) end_if:
					 
				  return([OPTIMAL,erg,T[3]])

				end_proc:


				
unalias(Tableau):
unalias(Heap):
