//    
// sello, 12.6.97, siehe Diplomarbeit Meinolf Sellmann 1997 

/*++
objpen.mu -- calculate for Tableau T the objective penalties for the variable
 	     associated with row k
++*/

alias(Heap = linopt::Heap):
alias(Tableau = linopt::Tableau):


  linopt::obj_penalty	:=	proc(T,k)

// Berechnet die Strafkosten der Variable in Zeile i des Tableaus T nach	
// dem zielfunktionsorientierten Verfahren				
// Eingabe: Ein Tableau T und ein Zeilenindex i				
// Ausgabe: Eine Liste mit 6 Elementen					
//	   1+2: Strafkosten fuer unteres und oberes Problem		
//	   3+4: assoziierte Pivotspalte fuer U- und O-Problem		
//	   5+6: geben an, ob fuer das untere bzw. das obere		
//		Problem ein Spezial-Pivotschritt um eine beidseitig	
//		beschraenkte Variable stattfinden muss.			


				local tbl,m,n,interval,integer,	// Tableaukomponenten 			
				      PO,PU,			// obere und untere Strafkosten 		
				      lU,lO,			// untere und obere Pivotspalte 		
				      miniU,miniO,		// Quotienten fuer das untere bzw.	
								// obere Problem zur Bestimmung der	
								// Pivotspalten				
				      interpivO,interpivU,	// intervalue-Pivot			
				      j;			// Laufvariable				

				begin
				  tbl := T[1]:
				  m := T[2]:
				  n := T[3]:
				  interval := T[9]:
				  integer := T[12]:

				  lU := []:
				  lO := []:
				  interpivU := []:
				  interpivO := []:

				  //k := i:

				  if interval[tbl[k,1],"greater"] = TRUE then 
				     //intervalpiv := TRUE:
				     j := 3:
				     while (j <= n+2) do
				       if interval[tbl[1,j],"greater"] = UNKNOWN and tbl[k,j] <> 0 then
					 return([0,0,[j],[j],[FALSE],[FALSE]])
				       end_if:
				       if tbl[k,j] < 0 
					 then if lU=[] 
						then miniU := -tbl[2,j]/tbl[k,j]:  
					             lU := [j]:
						     interpivU := [FALSE]
						elif -tbl[2,j]/tbl[k,j] < miniU
						    then miniU := -tbl[2,j]/tbl[k,j]:  
					      		 lU := [j]:
							 interpivU := [FALSE]
						    elif -tbl[2,j]/tbl[k,j] = miniU
							then lU := append(lU,j):
							     interpivU := append(interpivU,FALSE)
					      end_if	 
					 elif tbl[k,j] > 0 
					     then if lO=[] 
						    then miniO := tbl[2,j]/tbl[k,j]:  
					                 lO := [j]:
							 interpivO := [TRUE]
						    elif tbl[2,j]/tbl[k,j] < miniO
							then miniO := tbl[2,j]/tbl[k,j]:  
					                     lO := [j]:
							     interpivO := [TRUE]
							elif tbl[2,j]/tbl[k,j] = miniO
							    then lO := append(lO,j):
								 interpivO := append(interpivO,TRUE)  
						  end_if
				       end_if:	
				       j := j+1:					     
				     end_while:

				     if lU <> []
				       then PU := miniU*(1-tbl[k,2]+floor(tbl[k,2]))
				       else PU := infinity 
				     end_if:

				     if lO <> []
				       then PO := miniO*(tbl[k,2]-floor(tbl[k,2]))
				       else PO := infinity 
				     end_if

				  else 							// normal k found 
				     //intervalpiv := FALSE:
				     j := 3:
				     while (j <= n+2) do
				       if interval[tbl[1,j],"greater"] = UNKNOWN and tbl[k,j] <> 0 then
					 return([0,0,[j],[j],[FALSE],[FALSE]])
				       end_if:
				       if tbl[k,j] > 0 
					 then if lU=[] 
						then miniU := tbl[2,j]/tbl[k,j]:  
					             lU := [j]:
						     interpivU := [TRUE]
						elif tbl[2,j]/tbl[k,j] < miniU
						    then miniU := tbl[2,j]/tbl[k,j]:  
					      		 lU := [j]:
						         interpivU := [TRUE]
						    elif tbl[2,j]/tbl[k,j] = miniU
							then lU := append(lU,j):
							     interpivU := append(interpivU,TRUE)
					      end_if	 
					 elif tbl[k,j] < 0 
					     then if lO=[] 
						    then miniO := -tbl[2,j]/tbl[k,j]:  
					                 lO := [j]:
						         interpivO := [FALSE]
						    elif -tbl[2,j]/tbl[k,j] < miniO
							then miniO := -tbl[2,j]/tbl[k,j]:  
					                     lO := [j]:
							     interpivO := [FALSE]
							elif -tbl[2,j]/tbl[k,j] = miniO
							    then lO := append(lO,j):
								 interpivO := append(interpivO,FALSE)
						  end_if
				       end_if:	
				       j := j+1:					     
				     end_while:

				     if lU <> []
				       then PU := miniU*(tbl[k,2]-floor(tbl[k,2]))
				       else PU := infinity 
				     end_if:

				     if lO <> []
				       then PO := miniO*(1-tbl[k,2]+floor(tbl[k,2]))
				       else PO := infinity 
				     end_if

				  end_if:

				  return([PU,PO,lU,lO,interpivU,interpivO])

				end_proc:


				
unalias(Tableau):
unalias(Heap):

