//    
// sello, 12.6.97, siehe Diplomarbeit Meinolf Sellmann 1997 


/*++
plotline.mu -- generate the plot-statement for a line between minXY and maxXY, to be inserted in ->plot2d
++*/

alias(Heap = linopt::Heap):
alias(Tableau = linopt::Tableau):

linopt::plot_line	:=
proc(inteq,var,minX,maxX,minY,maxY)

  local /*i,*/ j,			// Laufvariablen					
  fakX,fakY,const,		// fakX*x + faky*y = const ist zu zeichen  
  minU,maxU,minV,maxV;	// Rahmen, innerhalb dessen gezeichnet wird	
  // u,v;			         // u bzw. v laeuft beim plotten			
  
begin
  fakX := 0:
  fakY := 0:
  const := 0:
  
  if testtype(inteq,"_plus") 				// test all operands of the equation 
    then for j from 1 to nops(inteq) do
           if testtype(op(inteq,j),"_mult")
             then if ( testtype(op(inteq,[j,2]),DOM_INT  ) or
                      testtype(op(inteq,[j,2]),DOM_FLOAT) or
                      testtype(op(inteq,[j,2]),DOM_RAT  ) ) and
                    testtype(op(inteq,[j,1]),DOM_IDENT)
                    then if op(inteq,[j,1])=var[1]
                           then fakX := op(inteq,[j,2])
                         elif op(inteq,[j,1])=var[2]
                           then fakY := op(inteq,[j,2])
                         else error("Plotting Area is only possible in two dimensions!")
                         end_if
                  else error("Plotting Area is only possible in two dimensions!")
                  end_if
           elif testtype(op(inteq,j),DOM_IDENT)
             then if op(inteq,j) = var[1]
                    then fakX := 1
							elif op(inteq,j) = var[2] 
                       then fakY := 1
                     else error("Plotting Area is only possible in two dimensions!")
                  end_if
           elif not ( testtype(op(inteq,j),DOM_INT  ) or
                     testtype(op(inteq,j),DOM_FLOAT) or
                     testtype(op(inteq,j),DOM_RAT  ) )
             then error("Plotting Area is only possible in two dimensions!")
           else const := op(inteq,j)
           end_if
         end_for
  elif testtype(inteq,"_mult")
    then if ( testtype(op(inteq,2),DOM_INT  ) or
             testtype(op(inteq,2),DOM_FLOAT) or
             testtype(op(inteq,2),DOM_RAT  ) ) and
           testtype(op(inteq,1),DOM_IDENT)
           then if op(inteq,1)=var[1]
                  then fakX := op(inteq,2)
                elif op(inteq,1)=var[2]
                  then fakY := op(inteq,2)
                else error("Plotting Area is only possible in two dimensions!")
                end_if
         else error("Plotting Area is only possible in two dimensions!")
         end_if
  elif testtype(inteq,DOM_IDENT)
    then if inteq = var[1]
           then fakX := 1
         elif inteq = var[2]
           then fakY := 1
         else error("Plotting Area is only possible in two dimensions!")
         end_if
  else error("Plotting Area is only possible in two dimensions!")
  end_if:
  
  if abs(fakX)<abs(fakY)
    then if -fakX/fakY > 0
           then minU := max(minX,((minY)*fakY+const)/(-fakX)):
           maxU := min(maxX,((maxY)*fakY+const)/(-fakX)):
           if minU < maxU then
             return(plot::Line2d([minU,(-fakX*minU-const)/fakY],
                                 [maxU,(-fakX*maxU-const)/fakY],
                                 Color=RGB::Black))
           end_if
         elif fakX <> 0
           then minU := max(minX,((maxY)*fakY+const)/(-fakX)):
           maxU := min(maxX,((minY)*fakY+const)/(-fakX)):
           if minU < maxU then
             return(plot::Line2d([minU,(-fakX*minU-const)/fakY],
                                 [maxU,(-fakX*maxU-const)/fakY],
                                 Color=RGB::Black))
           end_if
         elif -const/fakY <= maxY and -const/fakY >= minY
           then return(plot::Line2d([minX,-const/fakY],
                                    [maxX,-const/fakY],
                                    Color=RGB::Black))
         end_if
  elif -fakY/fakX > 0
    then minV := max(minY,((minX)*fakX+const)/(-fakY)):
    maxV := min(maxY,((maxX)*fakX+const)/(-fakY)):
    if minV < maxV then
      return(plot::Line2d([(-fakY*minV-const)/fakX,minV],
                          [(-fakY*maxV-const)/fakX,maxV],
                          Color=RGB::Black))
    end_if
  elif fakY <> 0
    then minV := max(minY,((maxX)*fakX+const)/(-fakY)):
    maxV := min(maxY,((minX)*fakX+const)/(-fakY)):
    if minV < maxV then
      return(plot::Line2d([(-fakY*minV-const)/fakX, minV],
                          [(-fakY*maxV-const)/fakX, maxV],
                          Color=RGB::Black))
    end_if
  elif -const/fakX <= maxX and -const/fakX >= minX
    then return(plot::Line2d([-const/fakX, minY],
                             [-const/fakX, maxY],
                             Color=RGB::Black))
  end_if:
  return(null())
end_proc:


				
unalias(Tableau):
unalias(Heap):
