/*++
Checks whether a list is contained in another one (respecting the order).
If the option Consecutive is given, the elements of the sublist must be
contained consecutively, i.e. without any other elements in between. The
return value is similar to contains: if the list is contained, the position
of its element in the container is returned; otherwise zero is returned.
Like for contains, it is possible to give as third argument an integer
which determines at which index value the search is started.
++*/


listlib::sublist := proc(l : DOM_LIST, s : DOM_LIST)
  local e, i, nl, ns, pos, res, cons;
begin
  case args(0)
  of 2 do
    cons := FALSE;
    pos := 1;
    break;
  of 3 do
    case domtype(args(3))
    of DOM_INT do
      cons := FALSE;
      pos := args(3);
      break;
    of DOM_IDENT do
      cons := bool(args(3)=hold(Consecutive));
      if not(cons) then
        error("unknown option");
      end_if;
      pos := 1;
      break;
    otherwise 
      error("wrong type of argument");
    end_case;
    break;
  of 4 do
    cons := bool(args(4)=hold(Consecutive));
    pos := args(3);
    if domtype(pos)<>DOM_INT or domtype(args(4))<>DOM_IDENT then
      error("wrong type of argument");
    end_if;
    if not(cons) then 
      error("unknown option");
    end_if;
    break;
  otherwise 
    error("wrong no of args");
  end_case;
  
  if s=[] then 
    return(0);
  end_if;
  if cons then
    e := s[1];
    delete s[1];
    ns := nops(s);
    nl := nops(l);
    pos := contains(l,e,pos);
    while (pos>0 and (nl-ns-pos)>=0) do
      res := TRUE;
      for i from 1 to ns do
        if l[pos+i]<>s[i] then
          res := FALSE;
          break;
        end_if;
      end_for;
      if res then 
        return(pos);
      end_if;
      pos := contains(l,e,pos+1);
    end_while;
    return(0);
  else
    res := contains(l,s[1],pos);
    if res=0 then 
      return(0);
    end_if;
    delete s[1];
    pos := res;
    for e in s do
      pos := contains(l,e,pos+1);
      if pos=0 then
        return(0);
      end_if;
    end_for;
    return(res);
  end_if;
end_proc:

