// 

// utilities for AC matching

// for speeding up int:
matchlib::_var_mayhave_X := TRUE:

matchlib::_var_mayhave_X_int :=
proc(ident)
  option remember;
  local s;
begin
  // all the vars allowed to have x either start with `#f...
  // or with the form `#?x`.
  s := expr2text(ident);
  return(bool(_lazy_and(length(s)> 3,
			s[3]="f" or s[4]="x")));
end_proc:
matchlib::_var_mayhave_X_int(`##123`) := TRUE:

matchlib::_remainders_to_vars :=
proc(terms, vars, fn)
  local terms_X, terms_noX,
	multiset_X, multiset_noX,
   partitions_X, partitions_noX,
	list_X, list_noX,
	vars_X, vars_noX,
   cartesProduct,
	nops_vars_X, nops_vars_noX,
	i, j, dummy;
begin
  [vars_X, vars_noX, dummy] := split(vars, matchlib::_var_mayhave_X);
  if vars_noX = [] then
    terms_X := terms;
    terms_noX := [];
    
    nops_vars_X := nops(vars_X);
    nops_vars_noX := 0;
    
    if nops_vars_X = 1 then
      return([[vars_X[1]=fn(op(terms))]])
    end;
    
    multiset_X := Dom::Multiset(op(terms));
    list_X := coerce(coerce(multiset_X, DOM_SET), DOM_LIST);
    list_noX := [];
    partitions_X :=
    (matchlib::_orderedMultisetPartitions
     ([Dom::Multiset::multiplicity(multiset_X, list_X[i])
       $ i=1..nops(list_X)],
      nops_vars_X));

    map(partitions_X,
        proc(selection)
        begin
          eval([vars_X[i]
                = fn((list_X[j]
                      $ selection[i][j])
                     $ j = 1..nops(selection[i]))
                $ i = 1..nops_vars_X
                ])
        end_proc
        )
  else
    [terms_X, terms_noX, dummy] := split([op(terms)], has, hold(_X));

    if vars_X = [] and terms_X <> [] then
      return([]);
    end_if;

    nops_vars_X := nops(vars_X);
    nops_vars_noX := nops(vars_noX);

    multiset_X := Dom::Multiset(op(terms_X));
    list_X := coerce(coerce(multiset_X, DOM_SET), DOM_LIST);
    multiset_noX := Dom::Multiset(op(terms_noX));
    list_noX := coerce(coerce(multiset_noX, DOM_SET), DOM_LIST);
    partitions_X :=
    matchlib::_orderedMultisetPartitions
    ([Dom::Multiset::multiplicity(multiset_X, list_X[i])
      $ i=1..nops(list_X)],
     nops_vars_X);
    partitions_noX :=
    matchlib::_orderedMultisetPartitions
    ([Dom::Multiset::multiplicity(multiset_noX, list_noX[i])
      $ i=1..nops(list_noX)],
     nops_vars_noX+nops_vars_X);

    cartesProduct := combinat::cartesianProduct(partitions_noX, partitions_X);

    map(cartesProduct,
        proc(selection)
          local selection_X, selection_noX;
        begin
          [selection_noX, selection_X] := selection;
      
          eval([vars_noX[i]
                = fn((list_noX[j]
                      $ selection_noX[i][j])
                     $ j = 1..nops(selection_noX[i]))
                $ i = 1..nops_vars_noX,
                vars_X[i]
                = fn((list_noX[j]
                      $ selection_noX[i+nops_vars_noX][j])
                     $ j = 1..nops(selection_noX[i+nops_vars_noX]),
                     (list_X[j]
                      $ selection_X[i][j])
                     $ j = 1..nops(selection_X[i]))
                $ i = 1..nops_vars_X
                ]);
        end_proc)
  end_if // vars_no_X = []
end_proc:

matchlib::_construct_AC_solutions :=
proc(template, indets_ordered, plain_indets, this_sol, subject, fn, conds)
  local ret, fixed, not_yet_used, j, tmp;
begin
  fixed := [];
  for j from 1 to nops(indets_ordered) do
    tmp := select(this_sol, proc(s) name doSelect; begin op(lhs(s),1)=j end);
    if nops(tmp) = 1 then // same as nops(tmp)>0
      fixed := fixed . zip(indets_ordered[j],rhs(op(tmp)),`=`);
    end_if;
  end_for;

  // places of sub-subjects not appearing in this_sol
  not_yet_used := {$1..nops(subject)} minus {op(map(this_sol, op, [1,2]))};

  if not_yet_used = {} then
    ret := [fixed.
	    map(plain_indets, `=`, matchlib::AC[fn])];
  else
    // the actual subterms not used
    not_yet_used := map
                    (not_yet_used,
                     proc(i)
                       name subterm;
                     begin
                       op(subject, i)
                     end);
    ret := matchlib::_remainders_to_vars(not_yet_used, plain_indets, fn);
    ret:= map(ret, l -> fixed. l);
  end_if;
  // check conditions
  ret := select(ret, c -> matchlib::lazy_and_is_subs(conds, c));
  
  return(map(ret, proc(s) name substemp; begin subs(template, s) end));
end:



/*
given a list m= [m[1], m[2], ..., m[n]], return a list of all lists of
nonnegative integers
l=[
[l[1][1], l[1][2], ..., l[1][n]],
[l[2][1], ....   ,    , l[2][n]],
.....
[l[k][1], ..... , ...., l[k][n]]
]

such that the sum of the entries in the j-th column equals m[j] 

*/
matchlib::_orderedMultisetPartitions:=
proc(m: DOM_LIST, k: Type::NonNegInt)
  local j, compos, transpose;
begin
  // this special case is used very often:
  if k=1 then
    return([[m]])
  end_if;
  if iszero(k) then
    return([])
  else
    transpose:=
    proc(mat)
    begin
      // mat is a list of lists, each of length k:
      assert(map({op(mat)}, nops) = {k});
      [map(mat, _index, j) $j=1..k]
    end_proc;
    compos:= map(m, combinat::compositions, MinPart = 0, Length = k);
    compos:= combinat::cartesianProduct(op(compos));
    map(compos, transpose)
  end_if;
end_proc:
