// 

// Construct left-to-right tree matching automata using prefix closures
// as defined by Albert Grf in "Left-to-Right Tree Pattern Matching",
// Rewriting Techniques and Applications, Springer, 1991

// This code is *not* intended for general use.  See Match::Compiler for
// the interface functionality.

// Note: PrefixTrees differ from expression trees in that the prefix tree
// of a single expression is always linear.  Each node has an arity --
// for nodes that are leaves in the expression tree, this arity is zero,
// for others it is the number of children.  Associative functions have
// an arity of -1 and the corresponding subtrees are stored separately.

/* TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO
   
  - pattern vars now represented as `##`(var) -- insert conditions here, too.


   TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO */


matchlib::PrefixTree := newDomain("matchlib::PrefixTree"):
matchlib::PrefixTreeResult := newDomain("matchlib::PrefixTreeResult"):
matchlib::PrefixTreeFixatedResults := newDomain("matchlib::PrefixTreeFixatedResults"):
matchlib::PrefixTreeReplacement := newDomain("matchlib::PrefixTreeReplacement"):
matchlib::PrefixTree::create_dom := hold(matchlib::PrefixTree):
matchlib::PrefixTreeResult::create_dom := hold(matchlib::PrefixTreeResult):
matchlib::PrefixTreeFixatedResults::create_dom := hold(matchlib::PrefixTreeFixatedResults):
matchlib::PrefixTreeReplacement::create_dom := hold(matchlib::PrefixTreeReplacement):

// Constructors

// matchlib::PrefixTreeResult collects results including conditions
// while building a tree.
matchlib::PrefixTreeResult::new :=
proc(result, conditions = [], AC_trees = [], replacements = [], vars={})
begin
  new(dom, result, conditions.dom::auto_conds(result), AC_trees, replacements, vars);
end_proc:

// callback for int
matchlib::PrefixTreeResult::auto_conds := () -> []:

matchlib::PrefixTreeResult::result       := x -> extop(x, 1):
matchlib::PrefixTreeResult::conditions   := x -> extop(x, 2):
matchlib::PrefixTreeResult::ACtrees      := x -> extop(x, 3):
matchlib::PrefixTreeResult::replacements := x -> extop(x, 4):
matchlib::PrefixTreeResult::vars         := x -> extop(x, 5):


matchlib::PrefixTreeResult::addACtree :=
proc(self, newTree)
begin
  subsop(self, 3 = extop(self, 3) . [newTree]);
end_proc:

matchlib::PrefixTreeResult::addReplacements :=
(self, newRepl) -> subsop(self, 4 = extop(self, 4) . newRepl):


matchlib::PrefixTreeResult::print :=
proc(self, indent=0)
  local conds, repls, AC, line, tmp;
begin
  line := _concat(" " $ indent,
      expr2text(dom::result(self)),
      "\n");
  conds := dom::conditions(self);
  if nops(conds) > 0 then
    line := _concat(line,
        (" " $ indent), "if   ", expr2text(conds[1]), "\n",
        ((" " $ indent)," and ", expr2text(tmp), "\n") $
        tmp in conds[2..-1]);
  end_if;
  repls := dom::replacements(self);
  if nops(repls) > 0 then
    line := _concat(line,
        (" " $ indent), "where ",
        matchlib::PrefixTreeReplacement::print(repls[1]),
        ((" " $ indent),"  and ",
         matchlib::PrefixTreeReplacement::print(tmp)) $
        tmp in repls[2..-1]);
  end_if;
  AC := dom::ACtrees(self);
  if nops(AC) > 0 then
    line := _concat(line,
        (" " $ indent), "AC:  ", expr2text(AC[1]), "\n",
        ((" " $ indent)," and ", expr2text(tmp),"\n") $
        tmp in AC[2..-1]);
  end_if;
  line
end_proc:

matchlib::PrefixTreeResult::expr2text :=
self -> "new(matchlib::PrefixTreeResult, " . expr2text(extop(self)) .")":


matchlib::PrefixTreeFixatedResults::AC_with_conds :=
proc(res : matchlib::PrefixTreeResult)
  local vars, conds, ACtrees;
begin
  vars := matchlib::PrefixTreeResult::vars(res);
  conds := matchlib::PrefixTreeResult::conditions(res);
  conds := map(conds, c -> [c, indets(c) intersect vars]);
  ACtrees := matchlib::PrefixTreeResult::ACtrees(res);
  map(ACtrees,
      proc(tree)
        local ACvars;
      begin
        ACvars := indets(tree) intersect vars;
        tree.[map(select(conds, c -> c[2] minus ACvars = {}), op, 1)].[vars]
      end_proc);
end:

//matchlib::PrefixTreeFixatedResults::

// after the tree has been built, each list of results
// is converted into a single matchlib::PrefixTreeFixatedResults,
// which uses only a single syntactic matching tree
// for the operands of each AC position.
matchlib::PrefixTreeFixatedResults::new :=
proc(results : Type::ListOf(matchlib::PrefixTreeResult))
  local retvals, conds, repls, ACtrees, positions, i, j, k,
  position, ACtreesHere, ACmatchers, tmp;
begin
  assert(nops(results) > 0);
  
  retvals := map(results, matchlib::PrefixTreeResult::result);
  conds := map(results, matchlib::PrefixTreeResult::conditions);
  repls := map(results, matchlib::PrefixTreeResult::replacements);
  ACtrees := map(results, matchlib::PrefixTreeFixatedResults::AC_with_conds);
  
  positions := {op(map(ACtrees[i], op, 1)) $ i = 1..nops(ACtrees)};
  assert(_lazy_and((positions = {op(map(ACtrees[i], op, 1))})
       $ i = 2..nops(ACtrees))); // same positions for each result
  assert({nops(positions)} =
   {op(map(ACtrees, nops))}); // each position used once
  
  // split each AC expression: pure vars first,
  // everything else second, list of vars in order to return,
  // then list of list of vars in second list, then conditions,
  // then vars.
  ACtrees := map(ACtrees, map,
     proc(x)
       local vars, other, dummy;
     begin
       [vars, other, dummy] := split([op(x[2])],
             t -> op(t, 0) = `##`);
       assert(dummy = []);
       vars := map(vars, op, 1);
       [x[1], vars, other,
        dom::getPatternVars(x[2]),
        map(other, dom::getPatternVars),
        x[3], x[4]]
     end_proc);
  
  ACmatchers := table();
  for position in positions do
    ACtreesHere := map(ACtrees, select, x->op(x,1)=position);
    // reduce to "other" + "conditions"
    ACtreesHere := map(ACtreesHere,
                       proc(tr)
                         local vars, conds;
                       begin
                         vars := op(tr, [1,7]);
                         conds := op(tr, [1,6]);
                         conds := map(conds, c -> [c, indets(c) intersect vars]);
                         map(op(tr, [1, 3]),
                             proc(ex)
                               local exv;
                             begin
                               exv := indets(ex) intersect vars;
                               [ex, map(select(conds, c -> c[2] minus exv = {}),
                                        op, 1)]
                             end);
                       end);
    assert(nops(ACtreesHere) = nops(ACtrees));
    
    tmp := matchlib::PrefixTree(FAIL, FAIL);
    k := 0;
    for i from 1 to nops(ACtreesHere) do
      for j from 1 to nops(ACtreesHere[i]) do
        k := k+1;
//  fprint(Unquoted, 0, "[A".expr2text(position).": ".expr2text(k)."  ".expr2text(time()));
        tmp := matchlib::PrefixTree::closure_union_intern
             (tmp,
              matchlib::PrefixTree
              (ACtreesHere[i][j][1],
               [i, j, dom::getPatternVars(op(ACtreesHere[i], j))],
               ACtreesHere[i][j][2]));
      end_for;
    end_for;
//    fprint(Unquoted, 0, "");
    ACmatchers[position] := matchlib::PrefixTree::toTable(tmp);
  end_for;
  new(dom, ACmatchers, ACtrees, retvals, conds, repls);
end_proc:

matchlib::PrefixTreeFixatedResults::ACmatchers   := x -> extop(x, 1):
matchlib::PrefixTreeFixatedResults::ACexprs      := x -> extop(x, 2):
matchlib::PrefixTreeFixatedResults::results      := x -> extop(x, 3):
matchlib::PrefixTreeFixatedResults::conditions   := x -> extop(x, 4):
matchlib::PrefixTreeFixatedResults::replacements := x -> extop(x, 5):

matchlib::PrefixTreeFixatedResults::getPatternVars :=
proc(expression)
  local poss, p;
begin
  poss := [prog::find(expression, `##`)];
  DOM_SET::sort({op(expression, (p[1..-2]).[1])
     $ p in poss});
end_proc:

matchlib::lazy_and_is_subs :=
proc(conds, substs)
  local cond, res;
begin
  for cond in conds do
    if traperror((res :=
		  is(eval
		     (eval
		      (matchlib::unblock
		       (subs(cond, substs))))))) <> 0 or
       res <> TRUE then
      return(FALSE);
    end_if;
  end_for;
  return(TRUE);
//    _lazy_and(op(map(map(conds[i], subs, vars),
//       is@matchlib::unblock)))
end_proc:

// This routine does the bulk of the work.
// It gets as its arguments a prefix tree with
// "fixated" results, i.e., one in a form more
// suited towards evaluation than to extending,
// and an expression.
// This prefix tree can either simply be a list
// of return patterns into which subexpressions
// of the second argument need to be substituted
// or it can contain AC subtrees, i.e., positions
// and helper matchers for subexpressions with
// an associative commutative function in their
// 0th operand.
matchlib::PrefixTreeFixatedResults::evalForInput :=
proc(self, expression)
  local vars, vars1, repls, repls1, subexpr,
  repls2, dummy, conds, results, i, j, k,
  result, ACmatchers, ACexprs, ACpositions,
  substs, pos, ACexprsThisPos, ACconds, ACpatvars,
  ACvarsThisPos, solThisPos, solThisPosAndPattern,
  nopsMatched, sol, ACretpatterns, ACresults,
  ACboundVars, sub, newsubsts, t, solThisPosSorted,
  any2set, listOfFirstOp, keys;
begin
  any2set := x -> {op(x)};
  any2set([]) := {};
  listOfFirstOp :=
       proc(x)
         option remember;
       begin
         map([op(x)], op, 1);
       end;
  keys := x -> map([op(x)], op, 1);
  keys(table()) := [];

  
  result     := [];
  repls      := dom::replacements(self);
  results    := dom::results(self);
  conds      := dom::conditions(self);
  ACexprs    := dom::ACexprs(self);
  ACmatchers := dom::ACmatchers(self);
  substs := [{[]}$ nops(results)]; // one possibility each, with no substs.
  
  // Are there any subtrees to consider?
  if nops(ACmatchers) > 0 then
    // If yes, they will all be at the same positions within the
    // expression and have the same head symbols, otherwise
    // we wouldn't have got here.
    ACpositions   := {op(map(ACexprs[1], op, 1))};
    // Now, for each of these positions, take the actual subtree
    // in the expression to match and subject it to the matcher
    // helper functions:
    for pos in ACpositions do
      ACresults     := table();
      t := map(ACexprs, select, proc(x) name doSelect; begin x[1]=pos end);
      ACexprsThisPos := map(t, op, [1, 3]);
      ACvarsThisPos  := map(t, op, [1, 2]);
      ACretpatterns  := map(t, op, [1, 4]);
      ACboundVars    := map(t, op, [1, 5]);
      ACpatvars      := map(t, op, [1, 7]);
      ACconds        := map(t, op, [1, 6]);
      ACconds := map(ACconds, c -> if c = FAIL then [] else c end);
      
      subexpr := op(expression, pos);
      solThisPosSorted := [[table() $ nops(subexpr)] $
         nops(ACexprsThisPos)];
      for i from 1 to nops(subexpr) do
        // here we match subproblems.  For each
        // position with an AC subtree, we have one
        // helper function (doing all patterns in parallel)
        // returning a list with entries
        // [patternNumber, operandOfPattern, [listOfVariableValues]].
        solThisPos := matchlib::evalFSA(op(subexpr, i),
                ACmatchers[pos]);
        // Then, rearrange them, because in the next step,
        // we'll need all matchings sorted by pattern,
        // while we create them in order of subexpressions:
        for t in solThisPos do
          solThisPosSorted[t[1]][i][t] := TRUE;
        end_for;
      end_for;
      // from nested list of tables to nested list of lists:
      solThisPosSorted := map(solThisPosSorted, map, keys);

      // check all the AC subpatterns, which of them still
      // could possibly match:
      for i from 1 to nops(ACexprsThisPos) do
        // any chance left to get a match for this pattern?
        if substs[i] = {} then next; end_if;
  
        // discard identical solutions
        solThisPosAndPattern := map(solThisPosSorted[i], any2set);

        if contains(solThisPosAndPattern, {}) > 0 and
           ACvarsThisPos[i] = [] then
          // something has no place to match to
          substs[i] := {};
          next;
        end_if;
  
        nopsMatched := nops(select(solThisPosAndPattern, `<>`, {}));
  
        if nopsMatched < nops(ACexprsThisPos[i]) or
           nops({op(map(solThisPosAndPattern,
            op@map, op, 2))}) < nops(ACexprsThisPos[i])
           then
          // some part of the pattern has no candidate
          substs[i] := {};
          next;
        end_if;
  
        // now, for each operand of the subject and each
        // operand of the pattern, find all possible variable
        // assignments:
        solThisPosAndPattern := table(([k, j] =
                     map(select(solThisPosAndPattern[j],
                                x -> op(x, 2) = k),
                         op, 3))
                    $ j = 1 .. nops(solThisPosAndPattern)
                   $ k = 1 .. nops(ACexprsThisPos[i]));
  
        solThisPosAndPattern := select(solThisPosAndPattern, x->rhs(x)<>{});
        //  print(solThisPosAndPattern, nopsMatched);
  
        // matchlib::solve_bipartite finds all maximal
        // matchings in the bipartite graph between pattern
        // positions and actual operands -- here the
        // associativity and commutativity are resolved.
        // Note: We have not included patterm variables
        // right below the AC symbol yet, so there may
        // (and often will) be operands not corresponding
        // to any pattern operand.
        solThisPosAndPattern := matchlib::solve_bipartite(solThisPosAndPattern,
                      nops(ACexprsThisPos[i]));
  
        //  print("ACretpatterns", ACretpatterns);
        //  print(solThisPosAndPattern);
  
        // from these, construct the solutions.
        // This includes setting all those operands of the
        // expression which for one solution found above do
        // not correspond to a pattern operand into all the
        // variables found directly below the AC head, in
        // all permissible combinations.
        for sol in solThisPosAndPattern do
          ACresults[nops(ACresults)] :=
          matchlib::_construct_AC_solutions
          ([i, ACretpatterns[i]],
           ACboundVars[i],
           ACvarsThisPos[i], sol,
	   op(expression, pos),  op(expression, pos.[0]),
	   ACconds[i]);
        end_for;
      end_for;
      // again, from table to list:
      ACresults := _concat(ACresults[i]$i=0..nops(ACresults)-1);
      
      // ACresults now contains lists of the form
      // [nrOfPattern, [variableValues]].  To use the
      // values in a substitution, we add the var names:
      ACresults := map(ACresults,
                       x -> [x[1],
                             zip(ACretpatterns[x[1]],
                                 x[2], `=`)]);
      
      newsubsts := [table()$nops(substs)];
      for i in ACresults do
        for sol in substs[i[1]] do
          newsubsts[i[1]][sol.i[2]] := TRUE;
        end_for;
      end_for;
      substs := map(newsubsts,
        x -> map({op(x)}, op, 1));
    end_for;
  end_if;

  // now, use the AC results 
  for i from 1 to nops(results) do
    if substs[i] = {} then next; end_if;
    [repls1, repls2, dummy] := split(repls[i],
                                     x -> extop(x, 2) <> FAIL);
    assert(dummy = []);
    vars1 := map(repls1,
     x -> op(x, 1) = op(expression, op(x, 2)));
    for sub in substs[i] do
      vars := vars1.sub;
      for repls1 in repls2 do
        vars := vars . [subs(repls1, vars)];
      end_for;
      
      // if evaluating the condition
      // or substituting into the result
      // yields an error, we *ignore* the candidate.
      dummy := result;
      if traperror((if matchlib::lazy_and_is_subs(conds[i], vars) then
                      dummy := result . [subs(results[i], vars, Unsimplified)];
                    end_if)) = 0 then
        result := dummy;
      end_if;
    end_for;
  end_for;
  result;
end_proc:

// a matchlib::PrefixTreeReplacement stores a replacement
// for a pattern variable.  It either stores a position
// in the input expression or an expression that may
// contain other pattern variables.
matchlib::PrefixTreeReplacement::new :=
proc(target, position, ex)
begin
  assert(position = FAIL or ex = FAIL);
  assert(position = FAIL or
   testtype(position, Type::ListOf(Type::Integer)));
  new(dom, target, position, ex);
end_proc:

matchlib::PrefixTreeReplacement::printxx :=
proc(self)
begin
  if extop(self, 2) = FAIL then
    expr2text(extop(self, 1)) . " = " . expr2text(extop(self, 3)) . "\n";
  else
    expr2text(extop(self, 1)) . " <-- op(input_expr, "
    . expr2text(extop(self, 2)) . ")\n";
  end_if;
end_proc:

matchlib::PrefixTreeReplacement::expr2textxx :=
self -> "new(matchlib::PrefixTreeReplacement, " . expr2text(extop(self)).")":


matchlib::PrefixTree::new :=
proc(ex, result, conds=[])
begin
  dom::convert(matchlib::unblock(ex), result, conds);
end_proc:

matchlib::PrefixTree::convert :=
proc(ex, result, conds : DOM_LIST)
  local vars;
begin
  vars := map({prog::find(ex, `##`)},
              p -> op(ex, p[1..-2].[1]));
  dom::expr2tree(ex, matchlib::PrefixTreeResult(result, conds, [], [], vars));
end_proc:

matchlib::PrefixTree::children := x -> extop(x, 1):
matchlib::PrefixTree::position := x -> extop(x, 2):
matchlib::PrefixTree::result   := x -> (assert(dom::isLeaf(x)); extop(x, 3)):

matchlib::PrefixTree::isLeaf   := x -> bool(dom::children(x) = table()):

matchlib::PrefixTree::addChild :=
proc(self, head, arity, newChild)
  local kids;
begin
  assert(domtype(newChild) = dom);
  kids := dom::children(self);
  if contains(kids, (head, arity)) then
    error("trying to add child for head already in use!")
  else
    kids[head, arity] := newChild;
  end_if;
  self := subsop(self, 1 = kids);
end_proc:


matchlib::PrefixTree::check_vars :=
proc(tree)
  local c;
begin
  if testargs() = FALSE then return(tree); end_if;
  
  if dom::isLeaf(tree) then
    return(tree);
  end_if;
  if dom::head_is_pattern(tree) then
    context(hold(assert)
      (dom::position(tree) = FAIL or
       dom::position(tree) = [] or
       dom::position(tree)[-1] <> 0));
  end_if;
  for c in dom::children(tree) do
    context(hold(dom::check_vars)(rhs(c)));
  end_for;
  tree;
end_proc:
  
// the actual constructor:
// convert an expression into a linear tree

// Because the later nodes need to be used
// as children of earlier nodes, we place them
// in a stack first.  Creating stacks is expensive,
// so we create two of them in a static variable.
// This implies that matchlib::PrefixTree::expr2tree
// is *not* reentrant!
proc()
  local positions_stack, domains_stack, typ;
  option escape;
begin
  positions_stack := adt::Stack();
  domains_stack := adt::Stack();
  typ := domtype@matchlib::unblock;
  
  matchlib::PrefixTree::expr2tree :=
  proc(ex, result)
    local subex, tree,
    subpos, head, i, pos, AC_positions,
    n_ops;
  begin
    pos := [];
    AC_positions := [];
    // clean up after there was an error last time:
    if not positions_stack::empty() or
       not domains_stack::empty() then
      warning("Found left-overs, hope there was an error earlier.");
    end_if;
    while not positions_stack::empty() do
      positions_stack::pop();
    end_while;
    while not domains_stack::empty() do
      domains_stack::pop();
    end_while;
//    positions_stack := adt::Stack(pos);
//    domains_stack := adt::Stack():
    positions_stack::push(pos);
    
    while not positions_stack::empty() do
      pos := positions_stack::pop();
      subex := matchlib::unblock(op(ex, pos));
      case typ(subex)
      of DOM_EXPR do
        head := matchlib::unblock(op(subex, 0));
        if contains(matchlib::AC, head) then
          result := matchlib::PrefixTreeResult::addACtree(result, [pos, subex]);
          domains_stack::push([head, pos, -1]);
        else
          if head = `##` then // pattern var
            assert(_lazy_or(pos=[], pos[-1] <> 0));
            result := matchlib::PrefixTreeResult::addReplacements
              (result, [matchlib::PrefixTreeReplacement(op(subex, 1),
                    pos, FAIL)]);
            domains_stack::push([`##`, pos, 0]);
          else
            subpos := nops(subex);
            for i from subpos downto 1 do
              positions_stack::push(pos.[i]);
            end_for;
            domains_stack::push([head, pos, subpos]);
          end_if;
        end_if;
        break;
      otherwise:
        domains_stack::push([subex, pos, 0]);
        break;
      end_case;
    end_while;
    
    tree := new(dom, table(), FAIL, [result]);
    while not domains_stack::empty() do
      [head, pos, n_ops] := domains_stack::pop();
      tree := new(dom, table((head, n_ops) = tree), pos, []);
    end_while;
    tree;
  end_proc:
end_proc():

// utility: does this tree start with a pattern var?
matchlib::PrefixTree::head_is_pattern :=
(self) -> _lazy_or(op(map([op(dom::children(self))],
        x -> op(x, [1,1]) = `##`))):


// add substitutions
matchlib::PrefixTree::insert_replacements :=
proc(tree, replacements)
begin
  if dom::isLeaf(tree) then
    subsop(tree, 3 = map(extop(tree, 3),
       matchlib::PrefixTreeResult::addReplacements,
       replacements));
  else
    subsop(tree, 1 = map(extop(tree, 1), map,
       matchlib::PrefixTree::insert_replacements,
       replacements));
  end_if;
end_proc:

// if possible, use this version:
matchlib::PrefixTree::subs :=
proc(tree, replacement)
  local kids, result, substs;
begin
  substs := args(2..args(0));
  kids := dom::children(tree);
  if kids <> FAIL then
    kids := table(map([op(kids)], subs, substs));
  end_if;
  result := dom::result(tree);
  if result <> FAIL then
    result := map(result, subs, substs);
  end_if;
  subsop(tree, 1=kids, 3=result);
end_proc:

// for prefix_with_patternvars:
matchlib::PrefixTree::addACtree :=
proc(tree, replacements)
begin
  if dom::isLeaf(tree) then
    subsop(tree, 3 = map(extop(tree, 3),
       matchlib::PrefixTreeResult::addACtree,
       replacements));
  else
    subsop(tree, 1 = map(extop(tree, 1), map,
       matchlib::PrefixTree::addACtree,
       replacements));
  end_if;
end_proc:


// When merging a tree with a pattern var as its head and
// a tree with some other head, the pattern variable must
// be replaced (in a copy) by the same function symbol
// with the same arity and pattern variables as its operands.

// TODO: Split properly for AC symbols

// This routine performs that action:
matchlib::PrefixTree::prefix_with_patternvars :=
proc(tree, head, arity)
  local position, i, kids, subtree;
begin
  position := dom::position(tree);
  
  kids := dom::children(tree);
  if not contains(kids, (head, arity)) then
    for subtree in kids do
    // subtree: (head, arity) = [child1, child2, ...]
      if op(subtree, [1, 2]) = 0 and
   op(subtree, [1, 1]) = `##` then
  assert(_lazy_or(position=[], position[-1]<>0));
  subtree := op(subtree, 2);
  for i from arity downto 1 do
    subtree := new(dom, table((`##`, 0) = subtree),
       position.[i], FAIL);
  end_for;
  if contains(matchlib::AC, head) then
    // `##`(`##123`) is hopefully always unused.
    // don't want to start genident(...) here.
    // the additional `##` around is needed as
    // a substitute for the AC symbol,
    // which is ignored, but stripped off.
    subtree := dom::addACtree(subtree, [position, `##`(`##`(`##123`))]);
  end_if;
  tree := dom::addChild(tree, head, arity, subtree);
      end_if;
    end_for;
  end_if;
  tree;
end_proc:


// the "remainder" of a prefix tree is a list of prefix trees
// below a certain head, including splits of pattern variables.

// TODO: Split properly for AC symbols
matchlib::PrefixTree::remainder :=
proc(tree, head, arity)
  local kids;
begin
  kids := dom::children(tree);
  if contains(kids, (head,arity)) then
// Note that a split on a pattern var is necessary only if
// no other match is found, since otherwise the tree would have
// been illegitimate anyway.
    return(kids[head, arity]);
  else
    tree := dom::prefix_with_patternvars(tree, head, arity);
    kids := dom::children(tree);
    if contains(kids, (head,arity)) then
      return(kids[head, arity]);
    else
      return(FAIL);
    end_if;
  end_if;
end_proc:

matchlib::PrefixTree::heads :=
proc(tree)
begin
  {op(map([op(dom::children(tree))],
        x -> [op(x, 1)]))} minus {[FAIL]};
end_proc:

// The union of prefix trees returns the closure of the union.
matchlib::PrefixTree::closure_union_intern :=
proc(tree1, tree2)
  local heads, head, tail1, tail2, result, pos;
begin
  assert(_lazy_or(dom::position(tree1) = dom::position(tree2)));
//      dom::position(tree1).[0] = dom::position(tree2),
//      dom::position(tree1) = dom::position(tree2).[0]));
  // by definition of prefix trees, if two trees share
  // the same prefix (and thus come here), it is
  // impossible that one of them is a leaf and the
  // other is not.
  assert(dom::isLeaf(tree1) = dom::isLeaf(tree2));
  
  if dom::isLeaf(tree1) then
//    result := listlib::removeDupSorted(dom::result(tree1).dom::result(tree2));
    result := [op({op(dom::result(tree1)), op(dom::result(tree2))})];
    return(subsop(tree1, 3=result));
  else
    // rename variables at the head (unify them)
//    [tree1, tree2] := dom::combine_var_heads(tree1, tree2);
  
    heads := dom::heads(tree1) union dom::heads(tree2);
    
    result := table();
    
    for head in heads do
      tail1 := dom::remainder(tree1, op(head));
      tail2 := dom::remainder(tree2, op(head));
      if tail1 = FAIL then
        assert(tail2 <> FAIL);
        result[op(head)] := tail2;
      elif tail2 = FAIL then
        result[op(head)] := tail1;
      else
        result[op(head)] := dom::closure_union_intern(tail1, tail2);
      end_if;
    end_for;
    pos := dom::position(tree1);
    if pos <> [] and pos[-1] = 0 then
      pos := dom::position(tree2);
    end_if;
    result := new(dom, result, pos, FAIL);
  end_if;
  result;
end_proc:

matchlib::PrefixTree::closure_union :=
misc::genassop(matchlib::PrefixTree::closure_union_intern,
         matchlib::PrefixTree(FAIL, FAIL)):

matchlib::PrefixTree::print :=
proc(self, indent = 0)
  local kids, kid, line;
begin
  kids := dom::children(self);
  if kids = table() then
    _concat(((line := matchlib::PrefixTreeResult::print(kid,
                 indent+5);
        line[indent+1 .. indent+4] := "-->";
        line)) $ kid in dom::result(self));
  else
    _concat
    ((// kid = ((head, arity) = [children])
      line := expr2text(op(kid, [1,1])) . "/" . expr2text(op(kid, [1,2])) .
      "  @  " . expr2text(dom::position(self)) . "\n";
      _concat((" " $ indent),
        line,
        dom::print(op(kid, 2), indent+1))) $ kid in kids);
  end_if;
end_proc:

matchlib::PrefixTree::expr2text :=
self -> "new(matchlib::PrefixTree, " . expr2text(extop(self)) . ")":


/************************************************************/

// transform the tree into a nested table of states:
matchlib::PrefixTree::toTable :=
proc(tree)
  local T, enter_at, i;
begin
  T := table();
  
  enter_at := proc(tree, at)
    local kids, k, t, x;
  begin
    if dom::isLeaf(tree) then
      T[at] := matchlib::PrefixTreeFixatedResults(dom::result(tree));
    else
      t := table();
      T[at] := FAIL;
      kids := [op(dom::children(tree))];
      for k in kids do
        x := nops(T)+1;
        T[x] := FAIL;
        enter_at(rhs(k), x);
        t[lhs(k)] := x;
      end_for;
      T[at] := t;
    end_if;
  end_proc:
  
  enter_at(tree, 1);
  
  [T[i] $ i = 1..nops(T)];
end_proc:

matchlib::evalFSA :=
proc(expression, FSA)
  local state, pos, nextStep, follow;
begin
  pos := [];
  state := 1;
  nextStep := FSA[1];
  
  follow := proc(pos)
    local subex, head, arity, i;
  begin
    if domtype(nextStep) <> DOM_TABLE then
      return(FALSE);
    end_if;
    subex := op(expression, pos);
    case domtype(subex)
    of DOM_EXPR do
      head := op(subex, 0);
      arity := nops(subex);
      if contains(nextStep, (head, arity)) then
        state := nextStep[head, arity];
        nextStep := FSA[state];
        for i from 1 to arity do
          if not follow(pos.[i]) then
            return(FALSE);
          end_if;
        end_for;
        return(TRUE);
      elif contains(nextStep, (head, -1)) then // AC
        state := nextStep[head, -1];
        nextStep := FSA[state];
        return(TRUE); // subtrees are handled later
      else // current head/arity not in tree
        if contains(nextStep, (`##`, 0)) then
          state := nextStep[`##`, 0];
          nextStep := FSA[state];
          return(TRUE);
        end_if;
        return(FALSE);
      end_if;
      break;
    otherwise:
      if contains(nextStep, (subex, 0)) then
        state := nextStep[subex, 0];
        nextStep := FSA[state];
        return(TRUE);
      elif contains(nextStep, (`##`, 0)) then
        state := nextStep[`##`, 0];
        nextStep := FSA[state];
        return(TRUE);
      else
        return(FALSE);
      end_if;
        end_case;
        return(FALSE);
      end_proc:
  
  if follow([]) and
     testtype(nextStep, matchlib::PrefixTreeFixatedResults) then
    matchlib::PrefixTreeFixatedResults::evalForInput(nextStep, expression);
  else
    []
  end_if;
end_proc:
