//   

// 

alias(CONST = matchlib::CONST):
alias(COMM  = matchlib::COMM):
alias(NULL  = matchlib::NULL):
alias(TYPE  = matchlib::TYPE):
alias(ASS   = matchlib::ASS):
alias(UASS  = matchlib::UASS):
alias(COND  = matchlib::COND):
alias(MATCH = matchlib::MATCH):

// initialize slots
matchlib::CONST := null():
matchlib::COMM  := null():
matchlib::NULL  := null():
matchlib::TYPE  := null():
matchlib::ASS   := null():
matchlib::UASS  := null():
matchlib::COND  := null():
matchlib::MATCH := null():

match:=
  proc(e = 0, p = 0)
    local k, n, c, ind, ind1, OPT, COND1;
    //option hold;
  begin
    // only options are selected from OPT; e and p are ignored
    OPT:= table(select(args(), X->type(X) = "_equal"));
    sysassign(CONST, {});
    sysassign(COMM, {hold(_mult), hold(_plus), hold(_and), hold(_or),
                     hold(_union), hold(_intersect)});
    sysassign(NULL, table(hold(_mult) = 1, hold(_plus) = 0,
                          hold(_and) = TRUE, hold(_or) = FALSE,
                          hold(_union) = {}, hold(_intersect) = universe));
    sysassign(TYPE, table(hold(_mult) = Type::Arithmetical,
                          hold(_plus) = Type::Arithmetical,
                          hold(_and) = Type::Boolean,
                          hold(_or) = Type::Boolean,
                          hold(_union) = Type::Set,
                          hold(_intersect) = Type::Set));
    // flattened by the kernel
    sysassign(ASS, {hold(_mult), hold(_plus), hold(_and), hold(_or),
                    hold(_union), hold(_intersect)});
    sysassign(COND, table());
    
    if contains(OPT, hold(Const)) then
      sysassign(CONST, OPT[hold(Const)])
    end_if;
    if contains(OPT, hold(Associative)) then
      // flatten user functions
//       e:= matchlib::flatass(e, OPT[hold(Associative)]);
//       p:= matchlib::flatass(p, OPT[hold(Associative)]);
      sysassign(ASS, ASS union OPT[hold(Associative)]);
      sysassign(UASS, OPT[hold(Associative)])
    else
      sysassign(UASS, {})
    end_if;
    if contains(OPT, hold(Commutative)) then
      sysassign(COMM, COMM union OPT[hold(Commutative)])
    end_if;
    if contains(OPT, hold(Null)) then
      sysassign(NULL, table(op(NULL), op(OPT[hold(Null)])))
    end_if;
    //e:= eval(e);
    //p:= eval(p);
    if contains(OPT, hold(Cond)) then
      COND1:= table();
      for k in OPT[hold(Cond)] do
        ind:= indets(p) minus CONST; // pattern variables
        ind1:=indets(e) minus CONST union indets(e) intersect indets(p);
        if domtype(k) = DOM_PROC then
          c:= k;
          n:= op(k, 1)
        elif domtype(k) = DOM_EXPR
             and (n:= indets(eval(indets(k))) minus ind1) intersect ind <> {} then
          c:= fp::unapply(k, op(n));
          n:= op(n)
        else
          if contains([TRUE, FALSE, UNKNOWN, FAIL, null()], k) > 0 then
            error("wrong condition '".expr2text(k)."'; try 'hold' to prevent evaluation")
          else
            error("wrong condition '".expr2text(k)."'")
          end_if
        end_if;
        if nops(n) > 1 then // some variables
          n:= [n];
          map(n, X -> if not contains(COND1, (X, 1)) then
                        COND1[X, 1]:= n
                      end_if)
        end_if;
        if contains(COND1, n) then
          COND1[n]:= append(COND1[n], c)
        else
          COND1[n]:= [c]
        end_if
      end_for;
      sysassign(COND, COND1)
    end_if;

    // init 
    sysassign(MATCH, table());
    matchlib::_match(e, p)
  end_proc:

matchlib::match:= match:

// e, p
matchlib::_match:= 
  proc(e, p, PSET = {}, T = Type::AnyType)
    local r, ret, m, i;
  begin
    //userinfo(2, "trying to match", e, "with pattern", p);

    // MATCH a pattern variable
    if type(p) = DOM_IDENT and not contains(Type::ConstantIdents, p) then // nur eine Variable
      if contains(CONST, p) then
        if e = p then
          return({})
        else
//fprint(0, ">>0", "identifiers doesnt match", e = p);
          return(FAIL)
        end_if
//      elif contains(MATCH, p) // contradiction with previous matching
//           and MATCH[p] <> e then
//        return(FAIL)
      elif has(PSET, p)
           and select(PSET, X -> op(X, 1) = p) <> {p = e} then
        // contradiction with previous matching
//fprint(0, ">>1", "contradiction", select(PSET, X -> op(X, 1) = p) <> {p = e}, "  set ", PSET);
        return(FAIL)
      elif contains(COND, p) then // condition for one variable
        if traperror((r:= _and(bool(op(COND[p], i)(e)) $ i = 1..nops(COND[p])))) = 0
           and r = TRUE and testtype(e, T) then
          // remember solution
          matchlib::identify(e, p);
          return({p = e})
        else
//fprint(0, ">>2", "condition failed for", p = e);
          return(FAIL)
        end_if
      elif contains(COND, (p, 1)) then // condition for more variables
        // variables that was found
        r:= COND[p, 1];
        m:= map(r, X -> if X = p then
                          e
                        elif contains(MATCH, X) then
                          MATCH[X]
                        else
                          FAIL
                        end);
        if contains(m, FAIL) = 0 // all variables used
           and traperror((r:= _and(bool(op(COND[r], i)(op(m)))
                                   $ i = 1..nops(COND[r])))) = 0
           and r <> TRUE then
          // one contradiction
//fprint(0, ">>2", "at least one condition failed for", p = e);
          return(FAIL)
        end_if;
        // remember solution
        matchlib::identify(e, p);
        return({p = e})
      elif testtype(e, T) then
        // remember solution
        matchlib::identify(e, p);
        return({p = e})
      else
//fprint(0, ">>3", "wrong type", hold(testtype)(e,  T), p = e);
        return(FAIL)
      end_if
    // each pattern variable matches itself -- not equations!!
    elif e = p and type(p) <> "_equal" then
      return(map(indets(p) minus matchlib::CONST, X -> X = X))
    // expressions
    elif domtype(e) = domtype(p) then
      if nops(e) = nops(p) then
        if domtype(p) = DOM_EXPR 
           and (m:= matchlib::_match(eval(op(e, 0)), eval(op(p, 0)))) <> FAIL then
          ret:= {};
          // identical structure
          for i from 1 to nops(e) do
            if (r:= matchlib::_match(op(e, i), op(p, i), ret union PSET))
              <> FAIL then
//              fprint(0, ">>3a", "call union with", ret, r);
              ret:= matchlib::_union(ret, r);
              if ret = FAIL then
//                fprint(0, ">>3b", "union failed with", ret, r);
                break
              end_if;
            else
              ret:= FAIL;
              break
            end_if
          end_for;
          if ret <> FAIL then
            return(_union(ret, m))
          end_if;

          // special case equation/unequation
          if type(e) = "_equal" or type(e) = "_unequal" then
            if (r := matchlib::_union(matchlib::_match(op(e, 2), op(p, 1)),
                                      matchlib::_match(op(e, 1), op(p, 2)))) <> FAIL then
              return(r)
            end_if
          end_if;
          
          // comm/ass with equal nops
          // commutative
          if contains(COMM, op(p, 0)) then
            r:= matchlib::_union(m, matchlib::matchcomm(op(p, 0),
                                                        matchlib::t2list(e, type(p)), [op(p)],
                                                        PSET));
            if r <> FAIL then
              return(r)
            end_if;
          else
            // 
            for i from 1 to nops(p) do
              r:= matchlib::_match(op(e, i), op(p, i), PSET);
              if r = FAIL then
//fprint(0, ">>4", "operand ", i, " doesnt match", r);
                return(FAIL) end_if;
              m:= matchlib::_union(m, r);
            end_for;
            return(m)
          end_if
          
        elif domtype(p) = DOM_LIST then
          ret:= {};
          for i from 1 to nops(e) do
            if (r:= matchlib::_match(op(e, i), op(p, i), ret union PSET)) <> FAIL then
              if (ret:= matchlib::_union(ret, r)) = FAIL then
                break
              end_if
            else
              ret:= FAIL;
              break
            end_if
          end_for;
          if ret <> FAIL then
            return(ret)
          end_if
        elif domtype(p) = DOM_SET then
          if (m:= matchlib::matchcomm(DOM_SET, [op(e)], [op(p)], PSET)) <> FAIL then
            return(m)
          end_if
        else // comm/ass with unequal nops
          if contains(COMM, op(p, 0))
            and (m:= matchlib::matchcomm(op(p, 0), matchlib::t2list(e, type(p)), [op(p)],
                                         PSET)) <> FAIL then
            return(m)
//           // associative
//           elif (ASS union UASS) intersect {op(e, 0), eval(op(e, 0)),
//                                            op(p, 0), eval(op(p, 0))} <> {} then
//             if (m:= matchlib::_match(eval(op(e, 0)), eval(op(p, 0)))) <> FAIL then
//               
//               //e:= [matchlib::flatass(op(e, 0), [op(e)])];
//               e:= [matchlib::flatass(op(e, 0), [op(e)])];
//               p:= [matchlib::flatass(op(p, 0), [op(p)])];
//               r:= matchlib::_union(m, matchlib::matchass(op(p, 0), e, p, PSET));
//               if r <> FAIL then
//                 return(r)
//               end_if
//             end_if
          end_if
        end_if
      else
        if (ASS union UASS) intersect {op(e, 0), eval(op(e, 0)),
                                       op(p, 0), eval(op(p, 0))} <> {} then
          if (m:= matchlib::_match(eval(op(e, 0)), eval(op(p, 0)))) <> FAIL then
            
            //e:= [matchlib::flatass(op(e, 0), [op(e)])];
            r:= matchlib::_union(m,
                                 matchlib::matchass(op(p, 0),
                                                    [matchlib::flatass(op(e, 0), [op(e)])],
                                                    [matchlib::flatass(op(p, 0), [op(p)])],
                                                    PSET));
            if r <> FAIL then
              return(r)
            end_if
          end_if
        end_if;
        if contains(COMM, op(p, 0))
          and (m:= matchlib::matchcomm(op(p, 0), matchlib::t2list(e, type(p)), [op(p)],
                                       PSET)) <> FAIL then
          return(m)
        end_if
      end_if
    //else
    end_if;

    // special mathematics
    if type(p) = "_power" then
      if type(e) = "_power" then
        r:= matchlib::_match(op(e, 1), op(p, 1));
        if r = FAIL then
          // try with power 1 (power 0 cannot be because e is a power) 
          matchlib::_union(matchlib::_match(e, op(p, 1)),
                           matchlib::_match(1, op(p, 2)))
        else // op(e, 1) and op(p, 1) match 
          matchlib::_union(r, matchlib::_match(op(e, 2), op(p, 2)))
        end_if
      else // e is not a power 
        if (r:= matchlib::_union(matchlib::_match(1, op(p, 2)),
                                 matchlib::_match(e, op(p, 1)))) // power 1
           <> FAIL then
          r
        elif (r:= matchlib::_union(matchlib::_match(0, op(p, 2)),
                                   matchlib::_match(e, 1))) <> FAIL then
          r
        elif op(p, 2) = -1 and e <> 0 // match 3/2 =~ 1/x
             and (domtype(e) = DOM_RAT or domtype(e) = DOM_INT) then 
          matchlib::_match(1/e, op(p, 1))
//// exp(1)^op(e) is simplified to exp(e) by the kernel	  
//        elif type(e) = "exp" // match exp(x) =~ exp(1)^y
//             and op(e) <> 1  // e is already exp(1)
//             and (r:= matchlib::_match(exp(1)^op(e), p)) <> FAIL then
//          r
        else
          FAIL          
        end_if
      end_if
    elif type(p) = "_plus" then
      r:= select(p, testtype, DOM_INT) + select(p, testtype, DOM_RAT);
      if r <> 0 then
        p:= p - r;
        e:= e - r
      end_if;
      if type(p) <> "_plus" then
        matchlib::_match(e, p)
      elif domtype(e) = DOM_COMPLEX // match complex numbers with sum 'a + b*I'
           and op((m:= split(p, has, I)), 1) <> 0
           and (r:= matchlib::_union(matchlib::_match(op(e, 1), op(m, 2)),
                                     matchlib::_match(op(e, 2)*I, op(m, 1)))) <> FAIL then
        return(r)
      else
        matchlib::matchcomm(hold(_plus), matchlib::t2list(e, "_plus"), [op(p)], PSET, 0)
      end_if
    elif type(p) = "_mult" then
      if e = 0 then
        for r in p do
          if (r:= matchlib::_match(0, r)) <> FAIL then
            return(r)
          end_if
        end_for;
        return(FAIL)
      end_if;
      r:= select(p, testtype, DOM_RAT)*select(p, testtype, DOM_INT);
      if r <> 1 then
        p:= p/r; e:= e/r
      end_if;
      if type(p) <> "_mult" then
        matchlib::_match(e, p)
      elif domtype(e) = DOM_COMPLEX and op(e, 1) = 0 // match imaginary numbers with prod 'b*I'
           and op((m:= split(p, _equal, I)), 1) <> 1
           and (r:= matchlib::_match(op(e, 2), op(m, 2))) <> FAIL then
        return(r)
      else
        p:= sort(matchlib::t2list(p, "_mult"), 
                ()->bool(length(args(1))>length(args(2))));
        matchlib::matchcomm(hold(_mult), matchlib::t2list(e, "_mult"), p, PSET, 1)
      end_if
    elif p = op(p) then
      if e = p then
        {}
      else
        FAIL
      end_if
    elif type(p) = "exp" then
      if e = 1 then
        matchlib::_match(0, op(p))
      elif type(e) = "_power" and type(op(e, 1)) = "exp" then
        matchlib::_match(op(e, [1, 1])*op(e, 2), op(p))
      else
        FAIL
      end_if
    else
      FAIL
    end_if;
  end_proc:

matchlib::_union:= 
  proc(a, b)
    option hold;
    local l;
  begin
    if (a:= context(a)) = FAIL then
      FAIL
    elif (b:= context(b)) = FAIL then
      FAIL
    else
      l:= [op(map(a, op, 1) intersect map(b, op, 1))];
      if subs(l, a) <> subs(l, b) then // parallel substitution
        FAIL
      else
        a union b
      end_if
    end_if
  end_proc:

matchlib::t2list:= (e, tp)->(if type(e) = tp then [op(e)] else [e] end_if):

matchlib::matchcomm:= 
  proc(OPR, e, p, PSET = {}, N = FAIL)
    local i, j, y, t, ret;
  begin
    if contains(TYPE, OPR) then
      t:= TYPE[OPR]
    else
      t:= null()
    end_if;
    if N = FAIL and contains(NULL, OPR) then
      N:= NULL[OPR]
    end_if;
    if p = [] then
      if e = [] then
        {}
      else
        FAIL
      end_if
    elif e = [] then
      FAIL
    elif nops(p) = 1 then
      if nops(e) > 1 then
        matchlib::_match(OPR(op(e)), op(p, 1), PSET, t)
      else
        matchlib::_match(op(e), op(p, 1), PSET, t)
      end_if
    else
      // select predefined assignments
      ret:= {};
      for y in PSET do
        if (j:= contains(p, op(y, 1))) > 0 then // expression
          if (i:= contains(e, op(y, 2))) > 0 then // pattern
            e:= subsop(e, i = null());
            p:= subsop(p, j = null());
            ret:= ret union {y}
          elif op(y, 2) = N then // pattern variable predefined with neutral element
            ret:= ret union {y}
          else // one variable with two values!
            return(FAIL)
          end_if
        end_if
      end_for;
      if e = [] then
        if p <> [] then
          // free variables left
          if N <> FAIL then
            // try to give them the neutral element
            t := {op(map(p, _equal, N))};
            if matchlib::_union(PSET, t) <> FAIL then
              return(ret union t)
            else
              return(FAIL)
            end_if
          else
            // no neutral element defined
            return(FAIL) // ??
          end_if
        end_if;
        return(ret)
      end_if;
      // special case: DOM_RAT =~ m/n
      // depends on the systems order:
      //    op(2/3*m) -> [m, 2/3]    (constant at last)
      //    op(n/m*X) -> [1/n, m, X] (expression in front)
      // ... to clean with option 'hold' in match
//       if domtype(op(e)) = DOM_RAT
//          and eval(OPR) = _mult and nops(p) = 2
//          and (y:= matchlib::_match([1/op(e, [1, 2]), op(e, [1, 1])], p)) <> FAIL then
//         return(y)
//       end_if;
      if eval(OPR) = _mult //and hastype(e, DOM_RAT) // hastype is to slow in some cases
         and (y:= matchlib::_match(map(e, X -> if domtype(X) = DOM_RAT then
                                                 op(X, 1), 1/op(X, 2)
                                               else
                                                 X
                                               end_if), p)) <> FAIL then
        return(y)
      end_if;
      // order significant for previous special case!
      for j from nops(p) downto 1 do
        for i from 1 to nops(e) do
          y:= matchlib::_union(matchlib::_match(op(e, i), op(p, j), PSET, t),
                               matchlib::matchcomm(OPR, subsop(e, i = null()),
                                                   subsop(p, j = null()), PSET, N));
          if y <> FAIL
             and (PSET = {} or PSET intersect op(y) <> {}) then
            return(y)
          end_if;
        end_for;
        if N <> FAIL then
            y:= matchlib::_union(matchlib::_match(N, op(p, j), PSET, t),
                                 matchlib::matchcomm(OPR, e, subsop(p, j = null()), PSET, N));
            if y <> FAIL then return(y) end_if
        end_if;
      end_for;
      FAIL
    end_if
  end_proc:

// flatten nested expressions
matchlib::flatass:=
  proc(OPR, e)
  begin
    op(map(e, X -> if op(X, 0) = OPR then
                     matchlib::flatass(OPR, [op(X)])
                   else
                     X
                   end_if))
  end_proc:

matchlib::matchass:= 
  proc(OPR, e, p, PSET = {}, N = FAIL)
    local i, j, ret, e1, p1, k;
  begin
    // [a, b, c, 1, d]
    // [X, 1, Y]
    ret:= {};
    if N = FAIL and contains(NULL, OPR) then
      N:= NULL[OPR]
    end_if;
    if {op(map(p, domtype))} = {DOM_IDENT}
       and {op(map(p, X -> contains(CONST, X)))} = {FALSE} then
      // only pattern variables
      if nops(p) <= nops(e) then
        for i from 1 to nops(p) - 1 do
          ret:= matchlib::_union(ret, matchlib::_match(op(e, i), op(p, i)));
          if ret = FAIL then
            break
          end_if
        end_for;
        if nops(p) < nops(e) then
          if contains(MATCH, OPR) then
            // found matching for operator
            OPR:= MATCH[OPR]
          end_if;
          matchlib::_union(ret, matchlib::_match(OPR(op(e, i..nops(e))), op(p, i)))
        else
          matchlib::_union(ret, matchlib::_match(op(e, i), op(p, i)))
        end_if
      else // too many pattern variables - filled with neutral element
        // [a, b] =~ [X, Y, Z]
        if contains(NULL, OPR) then
          for i from 1 to nops(e) do
            ret:= matchlib::_union(ret, matchlib::_match(op(e, i), op(p, i)));
            if ret = FAIL then
              break
            end_if
          end_for;
          if contains((i:= _union(matchlib::_match(NULL[OPR], op(p, i))
                                  $ i = nops(e)+1..nops(p))), FAIL) then
            return(FAIL)
          else
            matchlib::_union(ret, i)
          end_if
        else
          return(FAIL)
        end_if
      end_if
    else // pattern contains constants or/and expressions
      e1:= map(e, X -> bool(domtype(X) = DOM_IDENT) and not contains(CONST, X));
      p1:= map(p, X -> bool(domtype(X) = DOM_IDENT) and not contains(CONST, X));
      k:= 1;
      while (i:= contains(p1, FALSE, k)) > 0 do
        k:= i + 1;
        if (j:= contains(e, op(p, i))) = 0 then
          // no matching
          return(FAIL)
        else
          ret:= matchlib::_union(matchlib::matchass(OPR, [op(e, 1..j-1)],
                                                    [op(p, 1..i-1)], PSET, N),
                                 matchlib::matchass(OPR, [op(e, j+1..nops(e))],
                                                    [op(p, i+1..nops(p))], PSET, N));
          if ret <> FAIL then
            return(ret)
          end_if
        end_if
      end_while;
      FAIL
    end_if
  end_proc:

// if identifier 'p' matches identifier 'e' then
// remember the matching (MATCH) and
// identify information about ASS COMM and NULL
matchlib::identify:=
  proc(e, p)
  begin
    sysassign(MATCH, table(op(MATCH), p = e));
    if domtype(e) <> DOM_IDENT then
      return()
    end_if;
    if has(COMM, e) and not has(COMM, p) then
      sysassign(COMM, COMM union {p})
    end_if;
    if has(COMM, p) and not has(COMM, e) then
      sysassign(COMM, COMM union {e})
    end_if;
    if has(ASS, e) and not has(ASS, p) then
      sysassign(ASS, ASS union {p})
    end_if;
    if has(ASS, p) and not has(ASS, e) then
      sysassign(ASS, ASS union {e})
    end_if;
    if has(NULL, e) and not has(NULL, p) then
      sysassign(NULL, table(op(NULL), p = NULL[e]))
    end_if;
    if has(NULL, p) and not has(NULL, e) then
      sysassign(NULL, table(op(NULL), e = NULL[p]))
    end_if;
    return()
  end_proc: