
// misc::genassop -- generate associative operator from binary one

// misc::genassop(binaryop, zeroelement)

// binaryop - function accepting two arguments such that the associative law
//                 binaryop(binaryop(a, b),c)=
//                 binaryop(a, binaryop(b, c)
//            holds; this is not checked
// zeroelement - an element such that binaryop(a, zeroelement)=a
//            (this is also not checked)


// misc::genassop generates an associative operator. Let
// f:= misc::genassop(b,z). If there are  at least two arguments, the expression
// f(a1,...,an) is computed as b(f(a1...ah), f(a(h+1)...an)) where h = n div 2.
// If there is only one argument the expression f(a1) returns a1.
// If f is called with no argument, z is returned.

// The main usage of misc::genassop is to generate n-ary operations
// _plus and _mult from the binary case.

misc::genassop:=
proc(binop, zero)
  option escape;
begin
  if testargs() then
    if args(0) <> 2 then 
      error("Wrong number of arguments") 
    end_if;
    if not contains({DOM_PROC, DOM_FUNC_ENV}, domtype(args(1))) then
      error("First argument must be of type DOM_PROC or DOM_FUNC_ENV") ;
    end_if;
  end_if;
  
  proc()
    local i, r;
    name genericAssop;
  begin
    if args(0) = 0 then
      return(zero)
    end_if;
    r:= args(1);
    for i from 2 to args(0) do
      r:= binop(r, args(i))
    end_for;
    r
  end_proc
end_proc:
