

/*
    misc::greatestCommonExpression(a, x)

    returns the (unique) proper subexpression sub of a satisfying:
    1) any occurrence of x inside a is inside sub, i.e.,
       subsex(a, sub = something_new) contains no x anymore
    2) sub contains x
    3) sub is maximal with this property, i.e., it is not a proper
       subexpression of an expression also satisfying 1) 

    If a does not contain x or equals x, FAIL is returned

*/


misc::greatestCommonExpression:=
proc(a, x)
  local sub: DOM_LIST,
  l: DOM_LIST,
  newid: DOM_IDENT,
  newid2: DOM_IDENT,
  item, nextitem;
  
begin


  if type(x) <> DOM_IDENT then
    newid2:= #PLACEHOLDER2;
    if has(a, newid2) or has(x, newid2) then
      newid2:= genident()
    end_if;
    return(subs(misc::greatestCommonExpression(subsex(a, x=newid2), newid2),
                newid2 = x, Unsimplified))
  end_if;

  
  if not has(a, x) or a = x then
    return(FAIL)
  end_if;

  if type(a) = "_plus" or type(a) = "_mult" then
    item:= select(a, has, x);
    if item <> a then
      return(item)
    end_if
  end_if;


  newid:= #PLACEHOLDER;
 
  // to prepare for the unlikely:
  if has(a, newid) then
    newid:= genident()
  end_if;



  // find all proper subexpressions

  sub:= [];
  misc::maprec(a, (t->_lazy_and(has(t, x), t<>a, contains(sub, t) = 0)) =
               proc(s)
               begin
                 sub:= append(sub, s);
                 s
               end_proc
               );


  sub:= prog::sort(sub, length);
  // we assume that every expression has higher length that any
  // of its subexpressions

  assert(sub[1] = x);

  

  // loop invariant: sub contains at least one element,
  // and sub[1] is a common subexpression of all expressions containing x

  
  while nops(sub) > 1 do
    item:= sub[1]; // the greatest common subexpr found so far
    delete sub[1];
    nextitem:= sub[1];
    
    // if the next entry of sub is not contained in all other entries,
    // it cannot be the right result and later entries also cannot work
    // however, if it is a sum or product, it might be that a subsum or
    // subproduct works

    // we have to use subsex to find out that e.g. x+y is in 1/exp(x+y);
    // subs or has would not work
    if has(subsex(a, nextitem = newid), x) then
      if type(nextitem) <> "_plus" and type(nextitem) <> "_mult" then
        return(item)
      end_if;
      // form all subproducts / subsums and check them
      // since the first entry is shortest, its subsums/subproducts must be
      // even shorter
      
      l:= prog::sort
      ([op
      (map(select(combinat::powerset({op(nextitem)}), S-> nops(S) > 1),
          S-> op(nextitem, 0)(op(S))))
        ],
       length
      );
      // whatever result we find, it must contain item to be correct
      l:= select(l, has, item);
      if nops(l) = 0 then
        return(item)
      end_if;
      for nextitem in l do
        if has(subsex(a, nextitem = newid), x) then
          return(item)
        else
          item:= nextitem
        end_if
      end_for;
      return(item)
    end_if;
  end_while;
  sub[1]
end_proc: