//    

// andi, 13.05.94 

/*++
displace  - Unload a MuPAD modul

displace( mname )
displace( )

mname - name of module

This function unloads a module by using the function 'unloadmod'.
The argument will be evaluated. If it isn't a DOM_STRING then it
will be converted to a DOM_STRING.

For more information, refer to the MuPAD online-manual: 'unloadmod'.
++*/

module::displace:= proc( _m_ )
local	m, options;
begin
	if( args(0) = 0 ) then return( unloadmod() );
	end_if;
	if( domtype(_m_)=DOM_IDENT or domtype(_m_)=DOM_DOMAIN ) then
		m:= expr2text(_m_);
	elif( domtype(_m_)<>DOM_STRING ) then
		error( "Illegal argument" );
  else 
    m:= _m_;
	end_if;

	if( args(0) > 1 ) then
		options:= args(2..args(0));
	else
		options:= null();
	end_if;
	unloadmod(m, options);
end_proc:

// end of file 
