//    

// andi, 13.05.94 

/*++
func - Create the function-environment of a module-function

func( mname, fname )

mname - name of module
fname - name of module-function

This function returns the function-environment of the module-function
'mname::func' by using 'external'.  Both arguments will be evaluated.
If they aren't DOM_STRINGs then they will be converted to DOM_STRINGs
by using 'expr2text'.

For more information, refer to the MuPAD online-manual 'external'.
++*/

module::func:= proc( _m_, _f_ )
begin
	if( args(0) <> 2 ) then
		error( "Wrong number of arguments" );
	end_if;

	if( domtype(_f_)=DOM_IDENT or domtype(_f_)=DOM_FUNC_ENV ) then
		_f_:= expr2text(_f_);
	elif( domtype(_f_)<>DOM_STRING ) then
		error( "Illegal argument" );
	end_if;
	if( domtype(_m_)=DOM_IDENT or domtype(_m_)=DOM_DOMAIN ) then
		_m_:= expr2text(_m_);
	elif( domtype(_m_)<>DOM_STRING ) then
		error( "Illegal argument" );
	end_if;

	external( _m_, _f_ );
end_proc:

// end of file 
