//    

// andi, 13.05.94 

/*++
help - Print help information about a module (-function)

help( mname )
help( mname, fname )

mname - name of module
fname - name of module-function

This function defines the users help-interface for modules. The 
help-file for module 'xxx' has the name 'xxx.mdh' and should be
placed in the same directory as the module-file 'xxx.mdm'.

This function calls  "stdmod::help", which extracts the wanted
information from the help-file and returns it in a string. 

Both arguments will be evaluated.  If they aren't  DOM_STRINGs
then they will be converted to DOM_STRINGs by using 'expr2text'.
++*/

/*--
The format of module help-files (IMPORTANT !!!):

    (1)  General information about the module
    (2)  [ <!-- BEGIN-FUNC func_name -->
           Description of the function func_name
           <!--END-FUNC -->
	 ]*  (may be repeated 0,1,...)
    (3) Any text (not used)
--*/

module::help:= proc( _m_, _f_  )
    local _text_;
    save PRETTYPRINT;
begin
	PRETTYPRINT:= FALSE;

	if( args(0)=0 or args(0)>2 ) then
		print(	Unquoted,
	"\n".
	"Use  module::help(\"mod\") to get general information about the\n".
	"module 'mod' or modul::help(\"mod\",\"fun\") to get a description\n".
	"of the module function 'mod::fun'."
		);
		return();
	end_if;

	if( args(0) = 2 ) then
		if( domtype(_f_)=DOM_IDENT or domtype(_f_)=DOM_FUNC_ENV ) then
			_f_:= expr2text(_f_);
		elif( domtype(_f_)<>DOM_STRING ) then
			error( "Illegal argument" );
		end_if;
	else
		_f_:=null();
	end_if;
	if( domtype(_m_)=DOM_IDENT or domtype(_m_)=DOM_DOMAIN ) then
		_m_:= expr2text(_m_);
	elif( domtype(_m_)<>DOM_STRING ) then
		error( "Illegal argument" );
	end_if;
	if( (_text_:= external("stdmod","help")(_m_,_f_)) = FAIL ) then
		error( "No information available" );
	end_if;

	print( Unquoted, _text_ );
end_proc:
