//    

// andi, 13.05.94 

/*++
load  - Loads a MuPAD modul

load( mname )

mname - name of module

This function loads a MuPAD-module by using the function 'loadmod'.

The argument will be evaluated.  If it isn't a DOM_STRING  then it
will be converted to a DOM_STRING by using 'expr2text'.

For more information, refer to the MuPAD online-manual: 'loadmod'.
++*/

module::load:= proc( _m_ )
begin
	if( args(0) <> 1 ) then
		error( "Wrong number of arguments" );
	end_if;
	if( domtype(_m_)=DOM_IDENT or domtype(_m_)=DOM_DOMAIN ) then
		_m_:= expr2text(_m_);
	elif( domtype(_m_)<>DOM_STRING ) then
		error( "Illegal argument" );
	end_if;
	stdlib::syseval(loadmod( _m_ ));
end_proc:

// end of file 
