//    

// andi, 13.05/94 

/*++
which  - Determine the fullname (path) of a module

which( mname )

mname - name of module
                                             
This function returns the fullname (path) of a given module, by 
function 'stdmod::which'. The argument will be evaluated and if 
it isn't a  DOM_STRING then it will be converted to a DOM_STRING.

If the module 'mname' can't be found in the directories given 
by the MuPAD variable READPATH, in the current directory and 
in the MuPAD module-directory, then the function returns FAIL.

For more information, refer to the help-document of module
'stdmod'.
++*/

module::which:= proc( _m_ )
begin
	if( args(0) <> 1 ) then
		error( "Wrong number of arguments" );
	end_if;
	if( domtype(_m_) = DOM_IDENT or domtype(_m_) = DOM_DOMAIN ) then
		_m_:= expr2text(_m_);
	elif( domtype(_m_) <> DOM_STRING ) then
		error( "Illegal argument" );
   end_if;
   // resolve loadproc stdmod before using it
   stdmod:
	external("stdmod","which")( _m_ );
end_proc:

// end of file 
