/*----------------------------------------------------------------
The function abs is incredibly slow due to 
* much type checking 
* property calls.
If one knows that a symbolic expression such as
abs(sin(PI*x)) is used in a purely numerical
context (i.e., x will be substituted by a float), 
one wants a fast 'lazy' abs that becomes active 
only when its argument can be floated.  Here is 
this lazy abs.

For example, in the graphics, each occurrence of
abs should be replaced by numeric::abs:

Example:

// Old graphics before 3.0
time(plot(plot::Function2d(abs(sin(PI*x)), x = -1..1)))*msec,
time(plot(plot::Function2d(numeric::abs(sin(PI*x)), x = -1..1)))*msec;

                      1280 msec, 230 msec

// New graphics in 3.0
package("plot"): plotFileName:= "tmp.xvc":
time(plot(plot::Function2d(abs(sin(PI*x)), x = -1..1)))*msec,
time(plot(plot::Function2d(abs(sin(float(PI)*x)), x = -1..1)))*msec,
time(plot(plot::Function2d(numeric::abs(sin(PI*x)), x = -1..1)))*msec,
time(plot(plot::Function2d(numeric::abs(sin(float(PI)*x)), x = -1..1)))*msec;

            780 msec, 140 msec, 200 msec, 140 msec

// Note that some speedup is caused by an additional float:
// sin(3.1414*x) is faster than sin(PI*x) when x is a float.
----------------------------------------------------------------*/
numeric::abs:= proc(x) 
local fx;
begin
  fx:= float(x):
  if contains({DOM_FLOAT, DOM_COMPLEX}, domtype(fx)) then
       specfunc::abs(fx)
  else procname(args());
  end_if;
end_proc:
