//----------------------------------------------------------------
/* numerical factorization of a univariate polynomial

call:  numeric::factor(p, <FixedPrecision>, <Factor>, <SquareFree>, <NoWarning>  )

       p -- a univariate polynomial expression
(or    p -- a univariate polynomial of domain type DOM_POLY)

Synopsis: 
     numeric::factor(p) returns the polynomial p in factorized form
     (as an expression, not as a DOM_POLY!)
     It searches for all roots and returns
          ldegree(p)*(x - x1)^n1*(x - x2)^n2*...,
     where x1, x2, ... are the numerical roots and n1, n2, ...
     are the multiplicities.

Warning: this is just a version for undocumented internal use.
         Further type checking needs to be implemented before
         this can be made public!
*/
//-----------------------------------------
numeric::factor:= proc(p)
local X,  // the unknown
      roots, // the numerical roots
      r, lc;
begin
   case domtype(p) 
   of DOM_POLY do
         X:= op(p, 2): break;
   otherwise
         X:= numeric::indets(p): 
   end_case;
   if nops(X) > 1 then 
      error("expecting a univariate polynomial"):
   end_if;
   X:= op(X):
   if degree(p) = 0 then
      return(float(p))
   else
      roots:= numeric::polyroots(p, args(2..args(0)));
      lc:= lcoeff(p):
      if iszero(lc - 1) then
           return(_mult((X - r) $ r in roots));
      else return(float(lc)*_mult((X - r) $ r in roots));
      end_if;
   end_if;
end_proc:
