// Heuristic check on whether a univariate function has a zero in an interval.

numeric::hasroot :=
proc(f, x, a, b, eps=1e-3, maxsteps=250)
  local fp, fiv, fpiv, ivheap, iv, iv2, hiv2,
	c, w, smalliv, fl, fr, pf, bound;
begin
  if indets(a) <> {} or indets(b) <> {} or indets(f) minus {x} <> {} then
    return(UNKNOWN);
  end;
  [a, b] := float([a, b]);
  if a>=b then
    return(FALSE);
  end;
  
  // for polynomial inputs, we may be able to decrease the range:
  pf := poly(float(f), [x]);
  if pf <> FAIL and indets(poly2list(pf), All) = {} then
    bound := numeric::polyrootbound(pf);
    if a>bound or b < -bound then
      return(FALSE);
    end_if;
    a := max(a, -bound);
    b := min(b, bound);
  end_if;
  
  if domtype(interval(subs(f, x=a...b))) <> DOM_INTERVAL then
    // f not evaluable with intervals
    return(UNKNOWN);
  end;
  
  fp := diff(f, x);
  
  smalliv := 0;
  ivheap := adt::Heap();
  ivheap::insert(b-a, a...b);
  while maxsteps > 0 and
	ivheap::nops()>0 and
	smalliv < 50 do
    maxsteps := maxsteps - 1;
    iv := ivheap::delete_min();
    fiv := interval(subs(f, x=iv));
    if not 0 in fiv then
      next;
    end;
    if fiv = hull(0) then
      return(TRUE);
    end;
    if DOM_INTERVAL::width(iv) < eps then
      smalliv := smalliv + 1;
      next;
    end;
    fpiv := interval(subs(fp, x=iv));
    if domtype(fpiv) <> DOM_INTERVAL then
      // fp not evaluable with intervals
      return(UNKNOWN);
    end;
  
    if iszero(Im(fpiv)) and not 0 in hull(fpiv) and not has(fpiv, RD_INF) and not has(fpiv, RD_NINF) then
	// hull of f' does not contain 0, which implies it's defined
	// which implies continuity of f:
      fl := hull(subs(f, x=hull(op(iv, 1))));
      fr := hull(subs(f, x=hull(op(iv, 2))));
      if iszero(Im(fl)) and iszero(Im(fr)) and 0 >= fl*fr then
        return(TRUE);
      end;
      // in monotonuous cases, we may be able to deduce
      // that this interval cannot contain any root:
      if fpiv > 0 and (0 < fl or 0 > fr) then
        next;
      end_if;
      if fpiv < 0 and (0 > fl or 0 < fr) then
        next;
      end_if;
    end;
    if fpiv = hull(0) then
      iv2 := iv;
    else
      iv2 := interval(iv - subs(f/fpiv, x=iv));
    end_if;
    if iv2 <> {} then
      // is iv2 strictly inside iv?
      // if so, we've *proofed* the existence of a zero.
      // From what we put into ivheap, we know that iv is not a union:
      hiv2 := hull(iv2);
      if iszero(Im(hiv2)) then
        if op(hiv2, 1) > op(iv, 1) and op(hiv2, 2) < op(iv, 2) then
          return(TRUE);
        end;
      end_if;
      iv2 := iv2 intersect iv;
      if domtype(iv2) <> DOM_INTERVAL then
        // should not be possible
        return(UNKNOWN);
      end;
  
      if iv2 <> {} then
        if op(iv2, 0) = hold(_union) then
          map([op(iv2)], i -> ivheap::insert(DOM_INTERVAL::width(i), i));
        else
          // bisect
          assert(iszero(Im(iv2)));
          if op(iv2, 1) = RD_NINF then
            if op(iv2, 2) = RD_INF then
              c := 0.19872367;
            else
              c := rdplus(rdplus(op(iv2, 2), -abs(op(iv2, 2)), -1), -3.45671231, -1);
            end;
          else
            if op(iv2, 2) = RD_INF then
              c := rdplus(rdplus(op(iv2, 1), abs(op(iv2, 1)), 1), 3.45671231, 1);
            else
              c := 0.501286; // something non-round close to 1/2
              c := c*op(iv2, 1) + (1-c)*op(iv2, 2);
            end
          end;
          for iv in [subsop(iv2, 1=c), subsop(iv2, 2=c)] do
            if iv = iv2 then
              smalliv := smalliv + 1;
            else
              w := DOM_INTERVAL::width(iv);
              ivheap::insert(w, iv);
            end;
          end;
        end;
      end;
    end;
  end;
  if maxsteps = 0 then
    return(UNKNOWN);
  end_if;
  return(bool(smalliv>0 and UNKNOWN));
end:
