numeric::int:= proc()
local Args, result;
begin
   Args:= subs([args()], hold(int)=hold(numeric::quadrature));
   if domtype(Args[1]) = DOM_LIST or
      domtype(Args[1]) = DOM_SET or
      (Args[1])::dom::hasProp(Cat::Matrix) = TRUE then
      return(map(Args[1], numeric::int, op(Args[2..nops(Args)])));
   end_if;
   if traperror((result:= numeric::quadrature(op(Args)))) <> 0
   or has(result, hold(numeric::quadrature))
   or result=FAIL
      then Args:= subs(Args, hold(numeric::quadrature)=hold(numeric::int));
           return(hold(numeric::int)(op(Args)) )
      else return(result);
   end_if
end_proc:

numeric::int:= funcenv(numeric::int):

numeric::int::diff:= proc(f, var)
  local g, x, a, b, boundaryterm1, boundaryterm2, intops;
begin
  // f = numeric::int(g(x, var), x = a(var) .. b(var))
  if args(0) = 1 then
    return(f)
  end_if;
  g:= op(f, 1):
  x:= op(f, [2, 1]):
  a:= op(f, [2, 2, 1]):
  b:= op(f, [2, 2, 2]):
  intops:= op(f, 3..nops(f)); // options of numeric::int
  if var = x then
     // Derivative w.r.t. to the integration variable???
     // This is a user error, shall we throw an error?
     // No, just 0: return unevaluated diff@numeric::int
     return(float(0));
  end_if;
  if has(g, var) then
      f:= numeric::int(diff(g, var), x = a..b, intops);
    else
      f:= float(0):
  end_if:
  if has(a, var) then
      boundaryterm1:= subs(g, x = a, EvalChanges)*diff(a, var):
    else
      boundaryterm1:= float(0):
  end_if:
  if has(b, var) then
      boundaryterm2:= subs(g, x = b, EvalChanges)*diff(b, var):
    else
      boundaryterm2:= float(0):
  end_if:
  return(f + boundaryterm2 - boundaryterm1);
end_proc:

// This should always be consistent with int::freeIndets in the definite case!
numeric::int::freeIndets :=
proc(J)
  local x;
begin
  x := op(J, [2, 1]);
  (freeIndets(op(J, 1), args(2..args(0))) minus {x}) union
    freeIndets(op(J, [2, 2]), args(2..args(0)));
end_proc:

// This should always be consistent with int::evalAt in the definite case!
numeric::int::evalAt:=
proc(J: "function", subst: Type::SetOf("_equal"))
  local notx;
begin
  subst := select(subst, eq -> has(J, op(eq, 1)));
  assert(type(op(J, 2)) = "_equal" or type(op(J, 2)) = "_in");
  // in int(f(x), x=0..x) (which is legal in mupad!), we want to carry
  // out a substitution x=... only on the last x
  notx:= select(subst, s -> op(s, 1) <> op(J, [2, 1]));
  // if one of the substituted values contains our bound variable,
  // rename the bound variable first, to avoid aliasing problems.
  if has(notx, op(J, [2, 1])) then
    notx := notx union {op(J, [2, 1]) = solvelib::getIdent(Any, indets([args()]))};
  end_if;
  numeric::int(evalAt(op(J, 1), notx),
    subsop(op(J, 2),
      1 = evalAt(op(J, [2, 1]), notx),
      2 = evalAt(op(J, [2, 2]), subst)),
    op(J, 3..nops(J)))
end_proc:

