// Friedrich Schwarz 11.3.1994 

/*--
divisors(a) - returns the list of divisors of a
a - a non-zero integer

divisors uses ifactor
--*/

numlib::divisors :=
proc(a)
  local makeProducts, w, result, i, j;
begin
  if args(0) <> 1 then
    error("wrong number of arguments");
  elif not testtype(a,Type::Numeric) and domtype(a) <> Factored then
    return(procname(args()));
  elif domtype(a) <> DOM_INT and domtype(a) <> Factored then
    error("argument must be an integer");
  end_if;
  
  makeProducts :=
  proc(a,b)
  begin
    map(a, proc(x,y) begin op(map(y,_mult,x)); end_proc, b);
  end_proc;
  
  if iszero(a) then
    return([0])
  elif domtype(a) = Factored then
    w:= coerce(a, DOM_LIST);
    if Factored::getType(a) <> "irreducible" then
      error("Can only handle factorizations into irreducibles");
    end_if;
    if map({op(w)}, domtype) <> {DOM_INT} then
      error("Factorization must consist of integers");
    end_if;
  else  
    w := stdlib::ifactor(a);
  end_if;
  
  result := [1];
  for i from 1 to (nops(w)-1)/2 do
    [op(w,2*i)^j $ j = 1..op(w,2*i+1)];
    result := append(result,op(makeProducts(%,result)));
  end_for;
  sort(result);
end_proc:

