// Friedrich Schwarz 22.12.1996 

/*--
fibonacci(n) returns the nth Fibonacci number F_n
n - nonnegative integer

The algorithm simulates the intelligent calculation 
of powers [as used in the function powermod].
--*/

numlib::fibonacci := proc(n)
  local x, y, z, a, b, c, Z, C;
begin
  if args(0) <> 1 then
    error("wrong number of arguments");
  elif not testtype(n,Type::Numeric) then
    return(procname(args()));
  end_if;
  if domtype(n) <> DOM_INT or n < 0 then
    error("argument must be a nonnegative integer");
  end_if;
  
  if n = 0 then
    0;
  elif n = 1 then
    1;
  else
    x := 1;
    y := 0;
    z := 1;
    a := 1;
    b := 1;
    c := 0;
    while n > 1 do
      if modp(n,2) = 1 then
        Z := y*b + z*c;
        y := x*b + y*c; 
        z := Z;
        x := y + z; 
      end_if;
      C := b^2 + c^2;
      b := (a + c)*b;
      c := C;
      a := b + c; 
      n := n div 2
    end_while;
    x*b + y*c;
  end_if
end_proc:
