// Friedrich Schwarz 12.9.1994 

/*-----
hensel2(a,x,p,alpha) -- lifts a square root of a modulo p^(alpha - 1)
                        to a square root of a modulo p^alpha
a      -  a quadratic residue modulo p^alpha
x      -  a square root of a modulo p^(alpha - 1)
alpha  -  a natural number
p      -  a prime

The algorithm uses the appropiate special version of Hensel's lemma
-----*/

numlib::hensel2 := proc(a,x,p,alpha)
  local y, t, Beta;
begin
  y := x;
  if p > 2 then
    for Beta from 2 to alpha do
      t := (y^2 - a) div p^(Beta-1);
      y := y + modp(-t/(2*y),p)*p^(Beta-1)
    end_for;
    return(y)
  else  //p = 2
    for Beta from 4 to alpha do
      t := (y^2 - a) div 2^(Beta-1);
      y := y + modp(t,2)*2^(Beta-2)
    end_for;
    return(y)
  end_if
end_proc:
