// Friedrich Schwarz 7.9.1994 

/*--
ichrem -- generalized Chinese remainder algorithm
ichrem(a,m)
a - list of integers
m - list of natural numbers
--*/

numlib::ichrem := proc(a,m)
  local y, M, k, d;
begin
  if args(0) <> 2 then
    error("wrong number of arguments")
  elif nops(a) = 0 or nops(m) = 0 or nops(a) <> nops(m) then
    error("both arguments must be non-void lists of same length");
  elif domtype(a) <> DOM_LIST or domtype(m) <> DOM_LIST then
    error("1st argument must be a list of integers, ". 
          "2nd argument must be a list of positive integers");
  elif not {op(map(a,domtype))} = {DOM_INT} or
       not {op(map(m,domtype))} = {DOM_INT} or min(op(m)) < 1 then
    error("1st argument must be a list of integers, ". 
          "2nd argument must be a list of positive integers");
  end_if;
 
  y := modp(a[1],m[1]);
  M := m[1];
  for k from 1 to nops(a) - 1 do
    d := igcdex(M,m[k+1]);
    if modp(a[k+1] - y,d[1]) <> 0 then
      return(FAIL);
    else
      y := y + M*d[2]*((a[k+1] - y) div d[1]); 
      M := M*m[k+1]/d[1];
      y := modp(y,M);
    end_if
  end_for;
  return(y);
end_proc:
