/* numlib::ispower(a) checks if the positive integer a is an exact power p^n with n>=2,
  and returns p,n if yes, and FALSE otherwise
  Note: p is the smallest integer such that a=p^n
*/
numlib::ispower := proc(a) 
  local p,n;
begin
  if args(0) <> 1 then
    error("wrong number of arguments");
  elif not testtype(a,Type::Numeric) then
    return(procname(args()));
  elif domtype(a) <> DOM_INT then
    error("argument must be an integer");
  end_if;
  if a>3 then
    n:=round(ln(a)/ln(2));
    while n>=2 do
      p:=round(a^(1/n));
      if a=p^n then 
        return(p,n);
      end_if;
      n:=min(n-1,round(ln(a)/ln(p+1)));
    end_while
  end_if;
  FALSE;
end_proc:
