//    
// Stefan Wehmeier 16.4.1997 

/*-- 
Omega - Omega function
Omega(m)
m - natural number
--*/

numlib::Omega :=
proc(m)
  local p,i;
begin
  if args(0) <> 1 then
    error("wrong number of arguments");
  elif testtype(m,Type::Numeric) and (domtype(m) <> DOM_INT or m < 1) then
    error("argument must be a positive integer");
  end_if;

  if not testtype(m,Type::Numeric) then
    return(procname(args()))
  end_if;
  
  if m = 1 then
    0
  else
    p := stdlib::ifactor(m);
    _plus(p[2*i+1] $i=1..nops(p) div 2) 
  end_if
end_proc:

/*--
omega - Omega function
omega(m)
m - integer 
--*/

numlib::omega := subsop(numlib::numprimedivisors,6=hold(numlib::omega)): 
     
