// Friedrich Schwarz 28.3.1994 

/*--
order(a,m) - calculates the order of a in the group of units modulo m
a - integer
m - natural number

order uses ifactor
--*/

numlib::order := proc(a,m)
  local b, d; 
begin
  if args(0) <> 2 then
    error("wrong number of arguments");
  elif not testtype(a,Type::Numeric) or not testtype(m,Type::Numeric) then
    return(procname(args()));
  elif domtype(a) <> DOM_INT then
    error("1st argument must be an integer");
  elif domtype(m) <> DOM_INT or m < 1 then
    error("2nd argument must be a positive integer");
  end_if;
  
  b := modp(a,m);
  if igcd(b,m) <> 1 then
    return(FAIL)
  else
    for d in numlib::divisors(numlib::phi(m)) do
      if powermod(b,d,m) = 1 then
        break
      end_if
    end_for;
  return(d)
  end_if
end_proc:


      
