

/**********************************
numlib::pi(x)
x - integer, rational, or float

determines the number of primes below x 
**********************************/

numlib::pi:=
proc(x)
begin
  
  case domtype(x)
    of DOM_RAT do
    of DOM_FLOAT do
      x:= floor(x);
      break
    of DOM_INT do
      break;
    of DOM_COMPLEX do
      error("Illegal argument")
    otherwise
      if testtype(x, Type::Arithmetical) then
        return(procname(x))
      else
        error("Illegal argument")
      end_if
  end_case;

  if x < 2 then
    return(0)
  end_if;

  stdlib::pi(x)
end_proc:
