// Friedrich Schwarz 27.2.1997 

/*--
primroot(m)   - returns the least positive primroot modulo m
primroot(a,m) - returns the least primroot modulo m
                which is >= a
m - a natural number
a - an integer

method: brute force
primroot uses ifactor
--*/

numlib::primroot := proc()
  local w, ok, phim, m, a, primedivs, r, g,  q;
begin
  if args(0) = 1 then
    a := 1;
    m := args(1)
  elif args(0) = 2 then
    a := args(1);
    m := args(2)
  end_if;
  if args(0) = 0 or args(0) > 2 then
    error("wrong number of arguments")
  elif not testtype(a,Type::Numeric) or not testtype(m,Type::Numeric) then
    return(procname(args()));
  elif args(0) = 1 then
    if domtype(m) <> DOM_INT or m < 1 then
      error("argument must be a positive integer");
    end_if
  else
    if domtype(a) <> DOM_INT then
      error("1st argument must be an integer");
    elif domtype(m) <> DOM_INT or m < 1 then
      error("2nd argument must be a positive integer");
    end_if;
  end_if;

  if m = 1 then
    return(a);
  elif m = 2 then
    return(a + modp(a + 1,m));
  elif m = 4 then
    return(m*(a div m) + 3);
  else
    w := stdlib::ifactor(m);
    r := (nops(w) - 1)/2;
    if w[2] = 2 then
      if w[3] > 1 then
        return(FAIL);
      elif r > 2 then
        return(FAIL);
      end_if;
      phim := w[4]^(w[5]-1)*(w[4]-1);
      primedivs := numlib::primedivisors(w[4]-1);
      if w[5] > 1 then
        primedivs := append(primedivs,w[4]);
      end_if
    else 
      if r > 1 then 
        return(FAIL);
      end_if;
      phim := w[2]^(w[3]-1)*(w[2]-1);
      primedivs := numlib::primedivisors(w[2]-1);
      if w[3] > 1 then
        primedivs := sort(append(primedivs,w[2]));
      end_if
    end_if;
    for g from a to a + m - 1 do
      if igcd(g,m) = 1 then
        ok := TRUE;
        for q in primedivs do
          if powermod(g,phim/q,m) = 1 then
            ok := FALSE;
            break
          end_if
        end_for;
        if ok then
          return(g);
        end_if
      end_if
    end_for
  end_if
end_proc:
